package kdniao

import (
	"context"
	"github.com/gogf/gf/crypto/gmd5"
	"github.com/gogf/gf/encoding/gbase64"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/text/gregex"
	"time"
)

type Config struct {
	AppKey      string
	API         string
	EBusinessID string
}

var server *Config

const PkgName = "kdniao"

func New(req *Config) {
	server = req
	return
}

type CommonReq struct {
	RequestType string      `json:"RequestType"`
	EBusinessID string      `json:"EBusinessID"`
	DataType    string      `json:"DataType"` //请求、返回数据类型：2-json；
	RequestData interface{} `json:"RequestData"`
	DataSign    string      `json:"DataSign"`
}

func post(ctx context.Context, method string, RequestType string, req interface{}) (res string, err error) {

	Start := gtime.TimestampMilli()
	var params = CommonReq{
		RequestType: RequestType,
		EBusinessID: server.EBusinessID,
		DataType:    "2",
		RequestData: gjson.New(req).MustToJsonString(),
		DataSign:    sign(req),
	}

	Request := g.Client().ContentType("application/x-www-form-urlencoded; charset=utf-8")
	Request.Timeout(3 * time.Second)
	resp, err := Request.Post(server.API+method, params)
	defer func() {
		_ = resp.Close()
		ctx = context.WithValue(ctx, "Method", "POST")
		ctx = context.WithValue(ctx, "URI", method)
		if err != nil {
			g.Log().Ctx(ctx).Infof("参数【%v】错误【%v】响应时间【%v】", gjson.New(params).MustToJsonString(), err.Error(), gtime.TimestampMilli()-Start)
		} else {
			g.Log().Ctx(ctx).Cat(PkgName).Infof("参数【%v】响应【%v】响应时间【%v】", gjson.New(params).MustToJsonString(), res, gtime.TimestampMilli()-Start)
		}
	}()
	res = resp.ReadAllString()
	res, _ = gregex.ReplaceString(`\r|\n`, "", res)
	return
}

func sign(req interface{}) string {
	return gbase64.EncodeString(gmd5.MustEncryptString(gjson.New(req).MustToJsonString() + server.AppKey))
}
