package dwd

import (
	"context"
	"github.com/gogf/gf/container/garray"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

//商品
type goodsDwd struct {
}

var Goods = &goodsDwd{}

type GoodsListReq struct {
	ScrollId *int `json:"scroll_id,omitempty"`
	PageNum  int  `json:"page_num"`
	PageSize int  `json:"page_size"`
}
type GoodsListRes struct {
	Errno     int            `json:"errno"`
	Errmsg    string         `json:"errmsg"`
	Data      *GoodsListData `json:"data"`
	RequestId string         `json:"request_id"`
	Timestamp int            `json:"timestamp"`
	Signature string         `json:"signature"`
}

type GoodsListData struct {
	List []struct {
		ProductId         int      `json:"product_id"`
		CategoryId        string   `json:"category_id"`
		CategoryName      string   `json:"category_name"`
		Title             string   `json:"title"`
		BrandName         string   `json:"brand_name"`
		Desc              string   `json:"desc"`
		Tags              string   `json:"tags"`
		PlaceOfProduction string   `json:"place_of_production"`
		ItemImgs          []string `json:"item_imgs"`
		MainSkuId         int      `json:"main_sku_id"`
		Enabled           int      `json:"enabled"`
		MainSkuPrice      int      `json:"main_sku_price"`
		MainSkuPic        string   `json:"main_sku_pic"`
		Thumbnail         string   `json:"thumbnail"`
		Type              int      `json:"type"`
		IsInvoice         int      `json:"is_invoice"`
		IsNotExpiredDate  int      `json:"is_not_expired_date"`
		TaxCode           string   `json:"tax_code"`
		TaxRate           int      `json:"tax_rate"`
		Skus              []struct {
			SkuId            int      `json:"sku_id"`
			Stock            int      `json:"stock"`
			ManufacturedDate int      `json:"manufactured_date"`
			ExpiredDate      int      `json:"expired_date"`
			MarketPrice      int      `json:"market_price"`
			Price            int      `json:"price"`
			OutId            string   `json:"out_id"`
			ProductId        int      `json:"product_id"`
			SkuName          string   `json:"sku_name"`
			Thumbnail        string   `json:"thumbnail"`
			Enabled          int      `json:"enabled"`
			DeliveryFee      int      `json:"delivery_fee"`
			SkuImgs          []string `json:"sku_imgs"`
			SaleAttribute    []struct {
				AttributeName  string `json:"attribute_name"`
				AttributeValue string `json:"attribute_value"`
			} `json:"sale_attribute"`
		} `json:"skus"`
	} `json:"list"`
	PageSize int `json:"page_size"`
	TotalCnt int `json:"total_cnt"`
	ScrollId int `json:"scroll_id"`
}

func (*goodsDwd) List(ctx context.Context, req GoodsListReq) (res *GoodsListRes, err error) {
	var method = "goods.list"
	result, err := post(ctx, method, req)
	if err != nil {
		return
	}
	res = &GoodsListRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}

type GoodsDetailRes struct {
	Errno     int              `json:"errno"`
	Errmsg    string           `json:"errmsg"`
	Data      *GoodsDetailData `json:"data"`
	RequestId string           `json:"request_id"`
	Timestamp int              `json:"timestamp"`
	Signature string           `json:"signature"`
}

type GoodsDetailData struct {
	ProductId         int      `json:"product_id"`
	CategoryId        string   `json:"category_id"`
	CategoryName      string   `json:"category_name"`
	Title             string   `json:"title"`
	BrandName         string   `json:"brand_name"`
	Desc              string   `json:"desc"`
	Tags              string   `json:"tags"`
	PlaceOfProduction string   `json:"place_of_production"`
	ItemImgs          []string `json:"item_imgs"`
	MainSkuId         int      `json:"main_sku_id"`
	Enabled           int      `json:"enabled"`
	MainSkuPrice      int      `json:"main_sku_price"`
	MainSkuPic        string   `json:"main_sku_pic"`
	Thumbnail         string   `json:"thumbnail"`
	Type              int      `json:"type"`
	IsInvoice         int      `json:"is_invoice"`
	IsNotExpiredDate  int      `json:"is_not_expired_date"`
	TaxCode           string   `json:"tax_code"`
	TaxRate           int      `json:"tax_rate"`
	Skus              []struct {
		SkuId            int      `json:"sku_id"`
		Stock            int      `json:"stock"`
		ManufacturedDate int      `json:"manufactured_date"`
		ExpiredDate      int      `json:"expired_date"`
		MarketPrice      int      `json:"market_price"`
		Price            int      `json:"price"`
		OutId            string   `json:"out_id"`
		ProductId        int      `json:"product_id"`
		SkuName          string   `json:"sku_name"`
		Thumbnail        string   `json:"thumbnail"`
		Enabled          int      `json:"enabled"`
		DeliveryFee      int      `json:"delivery_fee"`
		SkuImgs          []string `json:"sku_imgs"`
		SaleAttribute    []struct {
			AttributeName  string `json:"attribute_name"`
			AttributeValue string `json:"attribute_value"`
		} `json:"sale_attribute"`
	} `json:"skus"`
}

//Detail 详情
func (*goodsDwd) Detail(ctx context.Context, GoodsID interface{}) (res *GoodsDetailRes, err error) {
	var method = "goods.detail"
	result, err := post(ctx, method, g.Map{
		"product_id": gconv.Int64(GoodsID),
	})
	if err != nil {
		return
	}
	//g.Log().Info(result.Data)
	res = &GoodsDetailRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}

type GoodsStockRes struct {
	Errno     int               `json:"errno"`
	Errmsg    string            `json:"errmsg"`
	Data      []*GoodsStockData `json:"data"`
	RequestId string            `json:"request_id"`
	Timestamp int               `json:"timestamp"`
	Signature string            `json:"signature"`
}
type GoodsStockData struct {
	SkuId   int `json:"sku_id"`
	Stock   int `json:"stock"`
	Enabled int `json:"enabled"`
}

//Stock 详情
func (*goodsDwd) Stock(ctx context.Context, skus *garray.Array) (res *GoodsStockRes, err error) {
	var method = "goods.stock"
	result, err := post(ctx, method, g.Map{
		"sku_ids": skus.Join(","),
	})
	if err != nil {
		return
	}
	//g.Log().Info(result.Data)
	res = &GoodsStockRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}

type GoodsAreaRes struct {
	Errno     int              `json:"errno"`
	Errmsg    string           `json:"errmsg"`
	Data      []*GoodsAreaData `json:"data"`
	RequestId string           `json:"request_id"`
	Timestamp int              `json:"timestamp"`
	Signature string           `json:"signature"`
}

type GoodsAreaData struct {
	SkuId        string `json:"sku_id"`
	DeliveryList []struct {
		ProvinceId   int    `json:"province_id,omitempty"`
		ProvinceName string `json:"province_name,omitempty"`
		CityList     []struct {
			CityId       string `json:"city_id"`
			CityName     string `json:"city_name"`
			DistrictList []struct {
				DistrictId   int    `json:"district_id"`
				DistrictName string `json:"district_name"`
			} `json:"district_list"`
		} `json:"city_list,omitempty"`
		SkuId        int           `json:"sku_id,omitempty"`
		DeliveryList []interface{} `json:"delivery_list,omitempty"`
	} `json:"delivery_list"`
}

//Area 可配送区域
func (*goodsDwd) Area(ctx context.Context, sku interface{}) (res *GoodsAreaRes, err error) {
	var method = "goods.deliveryAreaList"
	result, err := post(ctx, method, g.Map{
		"sku_id": gconv.Int64(sku),
	})
	if err != nil {
		return
	}
	//g.Log().Info(result.Data)
	res = &GoodsAreaRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}
