package hcw

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type OrderCreateReq struct {
	OrderSn            string        `json:"order_sn"`
	OrderPrice         int           `json:"order_price"`
	OrderDiscountPrice int           `json:"order_discount_price"`
	OrderFreightPrice  int           `json:"order_freight_price"`
	OrderPayPrice      int           `json:"order_pay_price"`
	OrderPayTime       string        `json:"order_pay_time"`
	OrderRemark        string        `json:"order_remark"`
	Source             string        `json:"source"`
	Address            *OrderAddress `json:"address"`
	Goods              *OrderGoods   `json:"goods"`
}

type OrderGoods struct {
	SpuNo      string `json:"goods_no"`        //商品ID
	Num        int    `json:"goods_num"`       //商品购买数量
	BuyPrice   int    `json:"goods_buy_price"` //商品购买价格
	PayPrice   string `json:"goods_pay_price"` //商品支付价格
	GoodsPrice int    `json:"goods_price"`     //商品单价
	SkuNo      string `json:"goods_sku_no"`    //商品sku
}

type OrderAddress struct {
	Name         string `json:"receive_name"`          //收货人名称
	Mobile       string `json:"receive_mobile"`        //收货人手机
	ProvinceName string `json:"receive_province_name"` //收货人省份
	CityName     string `json:"receive_city_name"`     //收货人城市
	AreaName     string `json:"receive_area_name"`     //收货人区
	StreetName   string `json:"receive_street_name"`   //收货人街道
	Address      string `json:"receive_address"`       //收货人具体地址
	ProvinceId   string `json:"receive_province_id"`   //收货人省份ID
	CityId       string `json:"receive_city_id"`       //收货人城市ID
	AreaId       string `json:"receive_area_id"`       //收货人区ID
	StreetId     string `json:"receive_street_id"`     //收货人街道ID
}

type OrderGoodsDetailList struct {
	Id               int    `json:"id"`
	GoodsOrderSn     string `json:"goods_order_sn"`
	GoodsId          int    `json:"goods_id"`
	Total            int    `json:"total"`
	CreatedTime      int    `json:"created_time"`
	Thumb            string `json:"thumb"`
	Title            string `json:"title"`
	GoodsPrice       int    `json:"goods_price"`
	GoodsOptionId    int    `json:"goods_option_id"`
	GoodsOptionTitle string `json:"goods_option_title"`
	GoodsCode        string `json:"goods_code"`
}

type OrderCreateRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Data    struct {
		OrderSn string `json:"order_sn"`
	} `json:"data"`
}

func (s *HcwClient) OrderCreate(ctx context.Context, req *OrderCreateReq) (res *OrderCreateRes, err error) {
	var method = "/api/v1/order"
	result, err := s.post(ctx, method, req)
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

type OrderListReq struct {
	Page     string `json:"page"`      //页数
	PageSize string `json:"page_size"` //条数
}

type OrderListRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Data    struct {
		List []struct {
			Id                 int         `json:"id"`
			OrderSn            string      `json:"order_sn"`
			ThirdOrderSn       string      `json:"third_order_sn"`
			ThreeOrderSn       string      `json:"three_order_sn"`
			OrderPrice         string      `json:"order_price"`
			OrderDiscountPrice string      `json:"order_discount_price"`
			OrderFreightPrice  string      `json:"order_freight_price"`
			OrderPayPrice      string      `json:"order_pay_price"`
			OrderPayTime       string      `json:"order_pay_time"`
			OrderFinishTime    interface{} `json:"order_finish_time"`
			OrderCancelTime    interface{} `json:"order_cancel_time"`
			OrderSendTime      interface{} `json:"order_send_time"`
			OrderType          int         `json:"order_type"`
			OrderStatus        int         `json:"order_status"`
			OrderPayStatus     int         `json:"order_pay_status"`
			SupplyType         string      `json:"supply_type"`
			OrderRemark        string      `json:"order_remark"`
			CreatedAt          string      `json:"created_at"`
			UpdatedAt          string      `json:"updated_at"`
		} `json:"list"`
		Total int `json:"total"`
	} `json:"data"`
}

func (s *HcwClient) OrderList(ctx context.Context, req *OrderCreateReq) (res *OrderListRes, err error) {
	var method = "/api/v1/order"
	result, err := s.get(ctx, method, req)
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

type OrderDetailRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Data    struct {
		Id                 int         `json:"id"`
		OrderSn            string      `json:"order_sn"`
		ThirdOrderSn       string      `json:"third_order_sn"`
		ThreeOrderSn       string      `json:"three_order_sn"`
		OrderPrice         string      `json:"order_price"`
		OrderDiscountPrice string      `json:"order_discount_price"`
		OrderFreightPrice  string      `json:"order_freight_price"`
		OrderPayPrice      string      `json:"order_pay_price"`
		OrderPayTime       string      `json:"order_pay_time"`
		OrderFinishTime    interface{} `json:"order_finish_time"`
		OrderCancelTime    interface{} `json:"order_cancel_time"`
		OrderSendTime      interface{} `json:"order_send_time"`
		OrderType          int         `json:"order_type"`
		OrderStatus        int         `json:"order_status"`
		OrderPayStatus     int         `json:"order_pay_status"`
		SupplyType         string      `json:"supply_type"`
		OrderRemark        string      `json:"order_remark"`
		CreatedAt          string      `json:"created_at"`
		UpdatedAt          string      `json:"updated_at"`
		DeletedAt          interface{} `json:"deleted_at"`
		OrderGoods         struct {
			OrderGoodsId  int         `json:"order_goods_id"`
			OrderSn       string      `json:"order_sn"`
			PlatOrderSn   interface{} `json:"plat_order_sn"`
			SupplyType    string      `json:"supply_type"`
			GoodsCode     string      `json:"goods_code"`
			GoodsName     string      `json:"goods_name"`
			GoodsNum      int         `json:"goods_num"`
			GoodsPrice    string      `json:"goods_price"`
			GoodsBuyPrice string      `json:"goods_buy_price"`
			GoodsPayPrice string      `json:"goods_pay_price"`
			GoodsSkuName  string      `json:"goods_sku_name"`
			GoodsSkuNo    string      `json:"goods_sku_no"`
			GoodsImage    string      `json:"goods_image"`
			CreatedAt     string      `json:"created_at"`
			UpdatedAt     string      `json:"updated_at"`
			DeletedAt     interface{} `json:"deleted_at"`
		} `json:"order_goods"`
		OrderAddress struct {
			OrderAddressId      int         `json:"order_address_id"`
			OrderSn             string      `json:"order_sn"`
			ReceiveName         string      `json:"receive_name"`
			ReceiveMobile       string      `json:"receive_mobile"`
			ReceiveAddress      string      `json:"receive_address"`
			ReceiveProvinceId   string      `json:"receive_province_id"`
			ReceiveCityId       string      `json:"receive_city_id"`
			ReceiveAreaId       string      `json:"receive_area_id"`
			ReceiverStreetId    string      `json:"receiver_street_id"`
			ReceiveProvinceName string      `json:"receive_province_name"`
			ReceiveCityName     string      `json:"receive_city_name"`
			ReceiveAreaName     string      `json:"receive_area_name"`
			ReceiveStreetName   string      `json:"receive_street_name"`
			CreatedAt           string      `json:"created_at"`
			UpdatedAt           string      `json:"updated_at"`
			DeletedAt           interface{} `json:"deleted_at"`
		} `json:"order_address"`
		OrderLogistics interface{} `json:"order_logistics"`
	} `json:"data"`
}

func (s *HcwClient) OrderDetail(ctx context.Context, orderSn string) (res *OrderDetailRes, err error) {
	var method = "/api/v1/order/" + orderSn
	result, err := s.get(ctx, method, g.Map{})
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

type OrderCheckReq struct {
	GoodsNo    string `json:"goods_no"`
	SkuNo      string `json:"sku_no"`
	BuyNum     string `json:"buy_num"`
	Source     string `json:"source"`
	ProvinceID string `json:"province_id"`
	CityID     string `json:"city_id"`
	AreaID     string `json:"area_id"`
}

type OrderCheckRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
}

func (s *HcwClient) OrderCheck(ctx context.Context, req *OrderCheckReq) (res *OrderCheckRes, err error) {
	var method = "/api/v1/order/check"
	result, err := s.post(ctx, method, req)
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
