package ikc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type couponIkc struct {
}

//Coupon 优惠券
var Coupon = couponIkc{}

type CouponListRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          []struct {
		Id              string  `json:"id"`
		Name            string  `json:"name"`
		CouponDesc      string  `json:"couponDesc"`
		Amount          float64 `json:"amount"`
		ThresholdAmount float64 `json:"thresholdAmount"`
		LiveId          string  `json:"liveId"`
		StartTime       string  `json:"startTime"`
		EndTime         string  `json:"endTime"`
		CurrentNum      int     `json:"currentNum"`
		RestrictNum     int     `json:"restrictNum"`
	} `json:"data"`
}

//List 列表
func (*couponIkc) List(ctx context.Context, liveIds string) (res *CouponListRes, err error) {
	method := "coupon/list"
	result, err := post(ctx, method, g.Map{
		"liveIds": liveIds,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type CouponDrawRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          struct {
		CouponUsedId    string `json:"couponUsedId"`
		Id              string `json:"id"`
		Name            string `json:"name"`
		Type            int    `json:"type"`
		CouponDesc      string `json:"couponDesc"`
		Time            string `json:"time"`
		OverTime        int64  `json:"overTime"`
		Amount          string `json:"amount"`
		ThresholdAmount string `json:"thresholdAmount"`
	} `json:"data"`
}

//Draw 领取
//`UserId` 外部渠道商用户ID
//`couponId` 优惠券ID
func (*couponIkc) Draw(ctx context.Context, UserId, couponId string) (res *CouponDrawRes, err error) {
	method := "coupon/draw"
	result, err := post(ctx, method, g.Map{
		"outerUserId": UserId,
		"couponId":    couponId,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type CouponRecommendReq struct {
	UserId      string                `json:"outerUserId"` //外部渠道商用户ID
	ProductList []CouponRecommendItem `json:"productList"`
}
type CouponRecommendItem struct {
	LiveId    string `json:"liveId"`    //活动 ID
	ProductId string `json:"productId"` //商品 ID
	Count     int    `json:"count"`     //数量
}

type CouponRecommendRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          []struct {
		Id              string  `json:"id"`
		CouponId        string  `json:"couponId"`
		Amount          float64 `json:"amount"`
		Name            string  `json:"name"`
		CouponDesc      string  `json:"couponDesc"`
		ThresholdAmount float64 `json:"thresholdAmount"`
		Time            string  `json:"time"`
		IsDefRecommend  int     `json:"isDefRecommend"`
	} `json:"data"`
}

//Recommend 已领推荐优惠券
func (*couponIkc) Recommend(ctx context.Context, req CouponRecommendReq) (res *CouponRecommendRes, err error) {
	method := "coupon/recommends"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type CouponHadReq struct {
	UserId   string `json:"outerUserId"` //外部渠道商用户ID
	Status   string `json:"status"`      //优惠券状态 0-未使用 2-已使用或者已失效
	PageNo   int    `json:"pageNo"`
	PageSize int    `json:"pageSize"`
}

type CouponHadRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          struct {
		Total          int `json:"total"`
		UserCouponList []struct {
			Id              string  `json:"id"`
			UseId           string  `json:"useId"`
			Name            string  `json:"name"`
			CouponDesc      string  `json:"couponDesc"`
			Amount          float64 `json:"amount"`
			ThresholdAmount float64 `json:"thresholdAmount"`
			OverTime        string  `json:"overTime"`
			Status          int     `json:"status"`
			Time            string  `json:"time"`
			Type            int     `json:"type"`
		} `json:"userCouponList"`
	} `json:"data"`
}

//Had 已领优惠券查询
func (*couponIkc) Had(ctx context.Context, req CouponHadReq) (res *CouponHadRes, err error) {
	method := "coupon/user-had"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}
