package ikucun

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type order struct {
}

var Order = order{}

type OrderCreateReq struct {
	ThirdUserId  string `json:"thirdUserId"`
	ThirdOrderNo string `json:"thirdOrderNo"`
	Receiver     struct {
		TownName      string `json:"townName"`
		DistrictCode  string `json:"districtCode"`
		CityName      string `json:"cityName"`
		DistrictName  string `json:"districtName"`
		TownCode      string `json:"townCode"`
		ProvinceCode  string `json:"provinceCode"`
		CityCode      string `json:"cityCode"`
		IdCardNo      string `json:"idCardNo"`
		Mobile        string `json:"mobile"`
		RecipientName string `json:"recipientName"`
		ProvinceName  string `json:"provinceName"`
		Address       string `json:"address"`
	} `json:"receiver"`
	SpuList []*OrderSpuList `json:"spuList"`
}

type OrderSpuList struct {
	Quantity           string `json:"quantity"`
	MarketingSalePrice string `json:"marketingSalePrice"`
	ExtSubOrderNo      string `json:"extSubOrderNo"`
	SpuId              string `json:"spuId"`
	SkuId              string `json:"skuId"`
}

type OrderCreateRes struct {
	Code    string `json:"code"`
	Success bool   `json:"success"`
	Message string `json:"message"`
	Data    struct {
		OrderGroupNo string `json:"orderGroupNo"`
		OrderList    []struct {
			OrderNo                 string `json:"orderNo"`
			PayOverTime             string `json:"payOverTime"`
			Quantity                int    `json:"quantity"`
			TotalProductAmount      int    `json:"totalProductAmount"`
			TotalDiscountAmount     int    `json:"totalDiscountAmount"`
			TotalCommission         int    `json:"totalCommission"`
			TotalCommissionAddition int    `json:"totalCommissionAddition"`
			Freight                 int    `json:"freight"`
			TotalTax                int    `json:"totalTax"`
			PaymentAmount           int    `json:"paymentAmount"`
			TotalProduct2CAmount    int    `json:"totalProduct2CAmount"`
			TotalDiscount2CAmount   int    `json:"totalDiscount2CAmount"`
			Payment2CAmount         int    `json:"payment2CAmount"`
			OrderSkuList            []struct {
				OrderSkuNo         string        `json:"orderSkuNo"`
				SpuId              string        `json:"spuId"`
				SkuId              string        `json:"skuId"`
				Quantity           int           `json:"quantity"`
				UnitPrice          int           `json:"unitPrice"`
				SpuAmount          int           `json:"spuAmount"`
				DiscountAmount     int           `json:"discountAmount"`
				SkuTax             int           `json:"skuTax"`
				SettlementAmount   int           `json:"settlementAmount"`
				Commission         int           `json:"commission"`
				CommissionAddition int           `json:"commissionAddition"`
				Spu2CAmount        int           `json:"spu2CAmount"`
				Discount2CAmount   int           `json:"discount2CAmount"`
				Settlement2CAmount int           `json:"settlement2CAmount"`
				OrderPromotionList []interface{} `json:"orderPromotionList"`
			} `json:"orderSkuList"`
		} `json:"orderList"`
	} `json:"data"`
}

func (s *order) Create(ctx context.Context, req *OrderCreateReq) (res *OrderCreateRes, err error) {
	method := "mengxiang.supply.order.create"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type OrderDetailReq struct {
	OrderNo string `json:"orderNo"`
}

type OrderDetailRes struct {
	Code    string `json:"code"`
	Success bool   `json:"success"`
	Message string `json:"message"`
	Data    struct {
		OrderNo               string `json:"orderNo"`
		OrderType             int    `json:"orderType"`
		OrderStatus           int    `json:"orderStatus"`
		OrderTime             string `json:"orderTime"`
		TotalProductAmount    int    `json:"totalProductAmount"`
		TotalDiscountAmount   int    `json:"totalDiscountAmount"`
		TotalCommission       int    `json:"totalCommission"`
		TotalIntegratedTax    int    `json:"totalIntegratedTax"`
		Freight               int    `json:"freight"`
		OrderGroupNo          string `json:"orderGroupNo"`
		PaymentAmount         int    `json:"paymentAmount"`
		TotalProduct2CAmount  int    `json:"totalProduct2CAmount"`
		TotalDiscount2CAmount int    `json:"totalDiscount2CAmount"`
		Payment2CAmount       int    `json:"payment2CAmount"`
		PayOverTime           string `json:"payOverTime"`
		BrandId               string `json:"brandId"`
		BrandName             string `json:"brandName"`
		BrandLogo             string `json:"brandLogo"`
		ThirdUserId           string `json:"thirdUserId"`
		SignType              int    `json:"signType"`
		ThirdOrderNo          string `json:"thirdOrderNo"`
		OrderSkuList          []struct {
			OrderSkuNo         string `json:"orderSkuNo"`
			OrderSkuStatus     int    `json:"orderSkuStatus"`
			SpuId              string `json:"spuId"`
			SkuId              string `json:"skuId"`
			UnitPrice          int    `json:"unitPrice"`
			ProductAmount      int    `json:"productAmount"`
			Product2CAmount    int    `json:"product2CAmount"`
			Discount2CAmount   int    `json:"discount2CAmount"`
			Settlement2CAmount int    `json:"settlement2CAmount"`
			Commission         int    `json:"commission"`
			DiscountAmount     int    `json:"discountAmount"`
			SkuTax             int    `json:"skuTax"`
			SettlementAmount   int    `json:"settlementAmount"`
			Quantity           int    `json:"quantity"`
			CancelQuantity     int    `json:"cancelQuantity"`
			DeliveryQuantity   int    `json:"deliveryQuantity"`
			UnDeliveryQuantity int    `json:"unDeliveryQuantity"`
			SpuName            string `json:"spuName"`
			SpuImage           string `json:"spuImage"`
			BrandName          string `json:"brandName"`
			BrandLogo          string `json:"brandLogo"`
		} `json:"orderSkuList"`
		Recipient struct {
			RecipientName string `json:"recipientName"`
			Mobile        string `json:"mobile"`
			Address       string `json:"address"`
			ProvinceCode  string `json:"provinceCode"`
			CityCode      string `json:"cityCode"`
			DistrictCode  string `json:"districtCode"`
			TownCode      string `json:"townCode"`
		} `json:"recipient"`
	} `json:"data"`
}

/*
*获取订单详情
 */
func (s *order) Detail(ctx context.Context, req *OrderDetailReq) (res *OrderDetailRes, err error) {
	method := "mengxiang.supply.order.detail"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type OderLogisticsReq struct {
	LogisticsNo   string `json:"logisticsNo"`
	LogisticsCode string `json:"logisticsCode"`
}

type OderLogisticsRes struct {
}

/*
*物流轨迹查询
 */
func (s *order) Logistics(ctx context.Context, req *OderLogisticsReq) (res *OderLogisticsRes, err error) {
	method := "mengxiang.supply.logistics.trace.get"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}
