package suning

import (
	"context"
	"encoding/base64"
	"github.com/gogf/gf/crypto/gmd5"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/util/gconv"
	"time"
)

var server *Config

//苏宁
const pkgName = "suning"

type Config struct {
	AppKey      string
	AppSecret   string
	ApiUrl      string
	VersionNo   string
	ChannelCode string
}

func New(req *Config) {
	server = req
	return
}

func sign(method string, date string, req string) string {
	signString := server.AppSecret + method + date + server.AppKey + server.VersionNo + base64.StdEncoding.EncodeToString([]byte(req))
	res := gmd5.MustEncryptString(signString)
	return res
}

func post(ctx context.Context, method string, req interface{}) (res string, err error) {
	Start := gtime.TimestampMilli()
	reqMap := gconv.Map(req)
	param := gjson.New(reqMap)
	Url := server.ApiUrl
	Request := g.Client()
	now := time.Now()
	formatted := now.Format("2006-01-02 15:04:05")
	Request.SetHeader("Content-Type", "text/xml; charset=utf-8")
	Request.SetHeader("AppMethod", method)
	Request.SetHeader("AppRequestTime", formatted)
	Request.SetHeader("Format", "json")
	Request.SetHeader("AppKey", server.AppKey)
	Request.SetHeader("VersionNo", server.VersionNo)
	Request.SetHeader("User-Agent", "suning-sdk-php")
	Request.SetHeader("Sdk-Version", "suning-sdk-php-beta0.1")
	Request.SetHeader("signInfo", sign(method, formatted, param.MustToJsonString()))
	resp, err := Request.Timeout(time.Second*10).Post(Url, param.MustToJsonString())
	defer func() {
		_ = resp.Close()
		ctx = context.WithValue(ctx, "Method", "POST")
		ctx = context.WithValue(ctx, "URI", Url)
		if err != nil {
			g.Log().Ctx(ctx).Cat(pkgName).Cat("error").Infof("参数【%v】错误【%v】响应时间【%v ms】", param.MustToJsonString(), err.Error(), gtime.TimestampMilli()-Start)
		} else {
			g.Log().Ctx(ctx).Cat(pkgName).Infof("参数【%v】响应【%v】响应时间【%v ms】", param.MustToJsonString(), res, gtime.TimestampMilli()-Start)
		}
	}()
	res = resp.ReadAllString()
	return
}
