package yunzmall

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type goodsLogic struct {
}

type GoodsCursorListReq struct {
	Cursor   int `json:"cursor,omitempty"` //游标
	PageSize int `json:"pageSize"`         //每页个数
}

type GoodsCursorListRes struct {
	CommonRes
	Data struct {
		List []struct {
			Id                   int     `json:"id"`
			Title                string  `json:"title"`
			ImageUrl             string  `json:"image_url"`
			Source               int     `json:"source"`
			Category1Id          int     `json:"category_1_id"`
			Category2Id          int     `json:"category_2_id"`
			Category3Id          int     `json:"category_3_id"`
			BrandId              int     `json:"brand_id"`
			AgreementPrice       int     `json:"agreement_price"`
			GuidePrice           int     `json:"guide_price"`
			ActivityPrice        int     `json:"activity_price"`
			MarketPrice          int     `json:"market_price"`
			SalePrice            int     `json:"sale_price"`
			CostPrice            int     `json:"cost_price"`
			OriginRate           float64 `json:"origin_rate"`
			ActivityRate         float64 `json:"activity_rate"`
			MarketRate           int     `json:"market_rate"`
			Profit               int     `json:"profit"`
			ProfitRate           float64 `json:"profit_rate"`
			IsDisplay            int     `json:"is_display"`
			IsRecommend          int     `json:"is_recommend"`
			IsNew                int     `json:"is_new"`
			IsHot                int     `json:"is_hot"`
			Stock                int     `json:"stock"`
			Sales                int     `json:"sales"`
			Unit                 string  `json:"unit"`
			IsPromotion          int     `json:"is_promotion"`
			MinPrice             int     `json:"min_price"`
			MaxPrice             int     `json:"max_price"`
			CreatedAt            int     `json:"created_at"`
			SupplierId           int     `json:"supplier_id"`
			GatherSupplierId     int     `json:"gather_supplier_id"`
			FreightType          int     `json:"freight_type"`
			RecommendBrandStr    string  `json:"recommend_brand_str"`
			RecommendCategoryStr string  `json:"recommend_category_str"`
			SupplierName         string  `json:"supplier_name"`
			UpdatedAt            int     `json:"updated_at"`
			Sort                 int     `json:"sort"`
			IsPlugin             int     `json:"is_plugin"`
			Level1Price          int     `json:"level_1_price"`
			Level2Price          int     `json:"level_2_price"`
			Level3Price          int     `json:"level_3_price"`
			Level4Price          int     `json:"level_4_price"`
			Level5Price          int     `json:"level_5_price"`
			Level6Price          int     `json:"level_6_price"`
			Level7Price          int     `json:"level_7_price"`
			Level8Price          int     `json:"level_8_price"`
			Level9Price          int     `json:"level_9_price"`
			Level10Price         int     `json:"level_10_price"`
			Level1Profit         int     `json:"level_1_profit"`
			Level2Profit         int     `json:"level_2_profit"`
			Level3Profit         int     `json:"level_3_profit"`
			Level4Profit         int     `json:"level_4_profit"`
			Level5Profit         int     `json:"level_5_profit"`
			Level6Profit         int     `json:"level_6_profit"`
			Level7Profit         int     `json:"level_7_profit"`
			Level8Profit         int     `json:"level_8_profit"`
			Level9Profit         int     `json:"level_9_profit"`
			Level10Profit        int     `json:"level_10_profit"`
			Barcode              string  `json:"barcode"`
			ImportApps           string  `json:"import_apps"`
			IsBill               int     `json:"is_bill"`
			SingleOption         int     `json:"single_option"`
			SmallShopIdString    string  `json:"small_shop_id_string"`
			SupplyLine           string  `json:"supply_line"`
			IsVideoShop          int     `json:"is_video_shop"`
		} `json:"list"`
		Total    int `json:"total"`
		Cursor   int `json:"cursor"`
		PageSize int `json:"pageSize"`
	} `json:"data"`
}

// GoodsCursorList 选品列表API(全量，cursor)
func (s *Client) GoodsCursorList(ctx context.Context, req GoodsCursorListReq) (res *GoodsCursorListRes, err error) {
	var method = "/app/product/storage/cursorList"
	result, err := s.post(ctx, method, gconv.Map(req))
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type GoodsDetailItem struct {
	Id             int    `json:"id"`
	CreatedAt      int    `json:"created_at"`
	UpdatedAt      int    `json:"updated_at"`
	Title          string `json:"title"`
	OriginPrice    int    `json:"origin_price"`
	GuidePrice     int    `json:"guide_price"`
	Price          int    `json:"price"`
	CostPrice      int    `json:"cost_price"`
	ActivityPrice  int    `json:"activity_price"`
	MinBuyQty      int    `json:"min_buy_qty"`
	Stock          int    `json:"stock"`
	Sales          int    `json:"sales"`
	FeedbackRate   int    `json:"feedback_rate"`
	Sn             string `json:"sn"`
	Code           string `json:"code"`
	IsNew          int    `json:"is_new"`
	IsRecommend    int    `json:"is_recommend"`
	IsHot          int    `json:"is_hot"`
	IsPromotion    int    `json:"is_promotion"`
	IsDisplay      int    `json:"is_display"`
	IsDisplayMsg   string `json:"is_display_msg"`
	StatusLock     int    `json:"status_lock"`
	SingleOption   int    `json:"single_option"`
	Desc           string `json:"desc"`
	ImageUrl       string `json:"image_url"`
	VideoUrl       string `json:"video_url"`
	Unit           string `json:"unit"`
	Barcode        string `json:"barcode"`
	Long           int    `json:"long"`
	Wide           int    `json:"wide"`
	High           int    `json:"high"`
	Volume         int    `json:"volume"`
	Freight        int    `json:"freight"`
	FreightType    int    `json:"freight_type"`
	MaxPrice       int    `json:"maxPrice"`
	MinPrice       int    `json:"minPrice"`
	MaxCostPrice   int    `json:"maxCostPrice"`
	MinCostPrice   int    `json:"minCostPrice"`
	MaxOriginPrice int    `json:"maxOriginPrice"`
	MinOriginPrice int    `json:"minOriginPrice"`
	Gallery        []struct {
		Type int    `json:"type"`
		Src  string `json:"src"`
	} `json:"gallery"`
	Qualifications interface{} `json:"qualifications"`
	DetailImages   string      `json:"detail_images"`
	Attrs          []struct {
		Name  string `json:"name"`
		Value string `json:"value"`
	} `json:"attrs"`
	BrandId                          int    `json:"brand_id"`
	SupplierId                       int    `json:"supplier_id"`
	GatherSupplyId                   int    `json:"gather_supply_id"`
	Category1Id                      int    `json:"category1_id"`
	Category2Id                      int    `json:"category2_id"`
	Category3Id                      int    `json:"category3_id"`
	FreightTemplateId                int    `json:"freight_template_id"`
	Source                           int    `json:"source"`
	Sort                             int    `json:"sort"`
	SourceGoodsId                    int    `json:"source_goods_id"`
	SourceGoodsIdString              string `json:"source_goods_id_string"`
	LocationId                       int    `json:"location_id"`
	Freeze                           int    `json:"freeze"`
	ShopLevel                        int    `json:"shop_level"`
	DesLevel                         int    `json:"des_level"`
	ExpressLevel                     int    `json:"express_level"`
	Level                            int    `json:"level"`
	ChildTitle                       string `json:"child_title"`
	BillPosition                     int    `json:"bill_position"`
	IsBill                           int    `json:"is_bill"`
	Md5                              string `json:"md5"`
	TaxCode                          string `json:"tax_code"`
	TaxProductName                   string `json:"tax_product_name"`
	TaxShortName                     string `json:"tax_short_name"`
	TaxOption                        string `json:"tax_option"`
	TaxUnit                          string `json:"tax_unit"`
	FavorablePolicy                  string `json:"favorable_policy"`
	IsFavorablePolicy                int    `json:"is_favorable_policy"`
	FreeOfTax                        int    `json:"free_of_tax"`
	ShortCode                        string `json:"short_code"`
	TaxMeasurePrice                  int    `json:"tax_measure_price"`
	TaxRate                          int    `json:"tax_rate"`
	IsTaxLogo                        int    `json:"is_tax_logo"`
	IsPlugin                         int    `json:"is_plugin"`
	PluginId                         int    `json:"plugin_id"`
	IsSingleOrder                    int    `json:"is_single_order"`
	SupplierSourceId                 int    `json:"supplier_source_id"`
	SupplierSourceCategoryId         int    `json:"supplier_source_category_id"`
	ProfitRate                       int    `json:"profit_rate"`
	JushuitanBind                    int    `json:"jushuitan_bind"`
	JushuitanDistributorSupplierName string `json:"jushuitan_distributor_supplier_name"`
	JushuitanDistributorCoId         string `json:"jushuitan_distributor_co_id"`
	JushuitanUploadStatus            int    `json:"jushuitan_upload_status"`
	SupplyLine                       string `json:"supply_line"`
	IsSupplyLine                     int    `json:"is_supply_line"`
	IsVideoShop                      int    `json:"is_video_shop"`
	ShopName                         string `json:"shop_name"`
	Skus                             []struct {
		Id            int    `json:"id"`
		CreatedAt     int    `json:"created_at"`
		UpdatedAt     int    `json:"updated_at"`
		Title         string `json:"title"`
		Price         int    `json:"price"`
		CostPrice     int    `json:"cost_price"`
		OriginPrice   int    `json:"origin_price"`
		GuidePrice    int    `json:"guide_price"`
		ActivityPrice int    `json:"activity_price"`
		Stock         int    `json:"stock"`
		Weight        int    `json:"weight"`
		IsDisplay     int    `json:"is_display"`
		ProductId     int    `json:"product_id"`
		SupplierId    int    `json:"supplier_id"`
		Code          string `json:"code"`
		Sn            string `json:"sn"`
		Barcode       string `json:"barcode"`
		ImageUrl      string `json:"image_url"`
		Options       []struct {
			SpecName     string `json:"spec_name"`
			SpecItemName string `json:"spec_item_name"`
		} `json:"options"`
		OriginalSkuId         int    `json:"original_sku_id"`
		SpecId                string `json:"specId"`
		Describe              string `json:"describe"`
		TaxCode               string `json:"tax_code"`
		TaxProductName        string `json:"tax_product_name"`
		TaxShortName          string `json:"tax_short_name"`
		TaxOption             string `json:"tax_option"`
		TaxUnit               string `json:"tax_unit"`
		FavorablePolicy       string `json:"favorable_policy"`
		IsFavorablePolicy     int    `json:"is_favorable_policy"`
		FreeOfTax             int    `json:"free_of_tax"`
		ShortCode             string `json:"short_code"`
		TaxMeasurePrice       int    `json:"tax_measure_price"`
		TaxRate               int    `json:"tax_rate"`
		IsTaxLogo             int    `json:"is_tax_logo"`
		ProfitRate            int    `json:"profit_rate"`
		JushuitanBind         int    `json:"jushuitan_bind"`
		JushuitanUploadStatus int    `json:"jushuitan_upload_status"`
		Number                int    `json:"number"`
	} `json:"skus"`
	Supplier struct {
		Id            int    `json:"id"`
		Name          string `json:"name"`
		IsSelfSupport int    `json:"is_self_support"`
	} `json:"supplier"`
	GatherSupply struct {
		Id         int    `json:"id"`
		Name       string `json:"name"`
		Key        string `json:"key"`
		CategoryId int    `json:"category_id"`
	} `json:"gather_supply"`
	AliProduct struct {
		Id           int         `json:"id"`
		CreatedAt    interface{} `json:"created_at"`
		UpdatedAt    interface{} `json:"updated_at"`
		ProductId    int         `json:"product_id"`
		SkuId        int         `json:"sku_id"`
		AliSkuId     string      `json:"ali_sku_id"`
		AliProductId int         `json:"ali_product_id"`
		AutoPay      int         `json:"auto_pay"`
		ShopId       string      `json:"shop_id"`
	} `json:"ali_product"`
	ProductVerify struct {
		Id         int         `json:"id"`
		CreatedAt  interface{} `json:"created_at"`
		UpdatedAt  interface{} `json:"updated_at"`
		ProductId  int         `json:"product_id"`
		SupplierId int         `json:"supplier_id"`
		Status     int         `json:"status"`
		IsDisplay  int         `json:"is_display"`
	} `json:"product_verify"`
	Brand struct {
		Id   int    `json:"id"`
		Name string `json:"name"`
	} `json:"brand"`
	Category1 struct {
		Id       int    `json:"id"`
		Name     string `json:"name"`
		Image    string `json:"image"`
		Level    int    `json:"level"`
		ParentId int    `json:"parent_id"`
	} `json:"category_1"`
	Category2 struct {
		Id       int    `json:"id"`
		Name     string `json:"name"`
		Image    string `json:"image"`
		Level    int    `json:"level"`
		ParentId int    `json:"parent_id"`
	} `json:"category_2"`
	Category3 struct {
		Id       int    `json:"id"`
		Name     string `json:"name"`
		Image    string `json:"image"`
		Level    int    `json:"level"`
		ParentId int    `json:"parent_id"`
	} `json:"category_3"`
	AgreementPrice int `json:"agreement_price"`
	MarketPrice    int `json:"market_price"`
	SalePrice      int `json:"sale_price"`
}

type GoodsDetailRes struct {
	CommonRes
	Data struct {
		List []GoodsDetailItem `json:"list"`
	} `json:"data"`
}

// GoodsDetail 商品详情
func (s *Client) GoodsDetail(ctx context.Context, req interface{}) (res *GoodsDetailRes, err error) {
	var method = "/app/product/storage/detailList"
	result, err := s.post(ctx, method, g.Map{
		"ids": gconv.Ints(req),
	})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type GoodsListReq struct {
	Title         string `json:"title,omitempty"`           //商品名称
	IsDisplay     int    `json:"is_display,omitempty"`      //0下架1上架
	RangeType     string `json:"range_type,omitempty"`      //筛选类型:agreement_price 协议价格	origin_rate常规利润率	activity_price 营销价格	guide_price  指导价格	activity_rate 营销利润率
	RangeTypeFrom int    `json:"range_type.from,omitempty"` //区间开始
	RangeTo       int    `json:"range.to,omitempty"`        //区间结束
	CategoryID1   int    `json:"category_1_id,omitempty"`   //一级分类id
	CategoryID2   int    `json:"category_2_id,omitempty"`   //二级分类id
	CategoryID3   int    `json:"category_3_id,omitempty"`   //三级分类id
	FreightType   int    `json:"freight_type,omitempty"`    //运费类型1包邮2不包邮
	Source        int    `json:"source,omitempty"`          // 0中台自营	1云仓（云仓）	2京东	6阿里	7天猫	8苏宁	11华南一仓	98中台云仓	99永源	100YZH	101中台供应链	102跨境	103DWD	108YHZ新版
	SupplierName  string `json:"supplier_name,omitempty"`   //供应商名称
	SupplierID    int    `json:"supplier_id,omitempty"`     //供应商ID
	Type          int    `json:"type,omitempty"`            // created_at:最新上架agreement_price:协议价格,	guide_price指导价	activity_price营销价格	origin_rate常规利率	activity_rate营销利率
	Sort          bool   `json:"sort,omitempty"`            // false 倒叙 true正序
	Page          int    `json:"page"`                      // 请求页数
	PageSize      int    `json:"pageSize"`                  // 每页个数（最大值50）
	IsNew         int    `json:"is_new,omitempty"`          // 新品:1是0否
	IsHot         int    `json:"is_hot,omitempty"`          // 热卖:1是0否
	IsPromotion   int    `json:"is_promotion,omitempty"`    // 促销:1是0否
	IsImport      int    `json:"is_import,omitempty"`       // 是否导入（当前配置是否导入过）:1是2否
}
type GoodsListRes struct {
	CommonRes
	Data struct {
		List []struct {
			Id                   int     `json:"id"`
			Title                string  `json:"title"`
			ImageUrl             string  `json:"image_url"`
			Source               int     `json:"source"`
			Category1Id          int     `json:"category_1_id"`
			Category2Id          int     `json:"category_2_id"`
			Category3Id          int     `json:"category_3_id"`
			BrandId              int     `json:"brand_id"`
			AgreementPrice       int     `json:"agreement_price"`
			GuidePrice           int     `json:"guide_price"`
			ActivityPrice        int     `json:"activity_price"`
			MarketPrice          int     `json:"market_price"`
			SalePrice            int     `json:"sale_price"`
			CostPrice            int     `json:"cost_price"`
			OriginRate           int     `json:"origin_rate"`
			ActivityRate         int     `json:"activity_rate"`
			MarketRate           int     `json:"market_rate"`
			Profit               int     `json:"profit"`
			ProfitRate           float64 `json:"profit_rate"`
			IsDisplay            int     `json:"is_display"`
			IsRecommend          int     `json:"is_recommend"`
			IsNew                int     `json:"is_new"`
			IsHot                int     `json:"is_hot"`
			Stock                int     `json:"stock"`
			Sales                int     `json:"sales"`
			Unit                 string  `json:"unit"`
			IsPromotion          int     `json:"is_promotion"`
			MinPrice             int     `json:"min_price"`
			MaxPrice             int     `json:"max_price"`
			CreatedAt            int     `json:"created_at"`
			SupplierId           int     `json:"supplier_id"`
			GatherSupplierId     int     `json:"gather_supplier_id"`
			FreightType          int     `json:"freight_type"`
			RecommendBrandStr    string  `json:"recommend_brand_str"`
			RecommendCategoryStr string  `json:"recommend_category_str"`
			SupplierName         string  `json:"supplier_name"`
			UpdatedAt            int     `json:"updated_at"`
			Sort                 int     `json:"sort"`
			IsPlugin             int     `json:"is_plugin"`
			Level1Price          int     `json:"level_1_price"`
			Level2Price          int     `json:"level_2_price"`
			Level3Price          int     `json:"level_3_price"`
			Level4Price          int     `json:"level_4_price"`
			Level5Price          int     `json:"level_5_price"`
			Level6Price          int     `json:"level_6_price"`
			Level7Price          int     `json:"level_7_price"`
			Level8Price          int     `json:"level_8_price"`
			Level9Price          int     `json:"level_9_price"`
			Level10Price         int     `json:"level_10_price"`
			Level1Profit         int     `json:"level_1_profit"`
			Level2Profit         int     `json:"level_2_profit"`
			Level3Profit         int     `json:"level_3_profit"`
			Level4Profit         int     `json:"level_4_profit"`
			Level5Profit         int     `json:"level_5_profit"`
			Level6Profit         int     `json:"level_6_profit"`
			Level7Profit         int     `json:"level_7_profit"`
			Level8Profit         int     `json:"level_8_profit"`
			Level9Profit         int     `json:"level_9_profit"`
			Level10Profit        int     `json:"level_10_profit"`
			Barcode              string  `json:"barcode"`
			ImportApps           string  `json:"import_apps"`
			IsBill               int     `json:"is_bill"`
			SingleOption         int     `json:"single_option"`
			SmallShopIdString    string  `json:"small_shop_id_string"`
			SupplyLine           string  `json:"supply_line"`
			IsVideoShop          int     `json:"is_video_shop"`
		} `json:"list"`
		Total      int    `json:"total"`
		Page       int    `json:"page"`
		PageSize   int    `json:"pageSize"`
		NextUrl    string `json:"next_url"`
		SeverRatio int    `json:"sever_ratio"`
	} `json:"data"`
}

// GoodsList 商品列表
func (s *Client) GoodsList(ctx context.Context, req GoodsListReq) (res *GoodsListRes, err error) {
	var method = "/app/product/storage/list"
	result, err := s.post(ctx, method, gconv.Map(req))
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
