package suning

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

//
type GoodsListReq struct {
	SnRequest struct {
		SnBody struct {
			QueryProdpool struct {
				ChannelCode string `json:"channelCode"`
				PageNo      string `json:"pageNo"`
				PageSize    string `json:"pageSize"`
				StartTime   string `json:"startTime"`
				EndTime     string `json:"endTime"`
			} `json:"queryProdpool"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

//
type GoodsListRes struct {
	SnResponseContent struct {
		SnHead struct {
			TotalSize     int    `json:"totalSize"`
			PageTotal     int    `json:"pageTotal"`
			PageNo        int    `json:"pageNo"`
			ReturnMessage string `json:"returnMessage"`
		} `json:"sn_head"`
		SnBody struct {
			QueryProdpool []struct {
				SpuId        string `json:"spuId"`
				SupplierCode string `json:"supplierCode"`
				SkuId        string `json:"skuId"`
			} `json:"queryProdpool"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 获取商品列表
func GetGoodsList(ctx context.Context, page, pageSize, startTime, endTime string) (res GoodsListRes, err error) {
	params := GoodsListReq{}
	params.SnRequest.SnBody.QueryProdpool.ChannelCode = server.ChannelCode
	params.SnRequest.SnBody.QueryProdpool.PageNo = page
	params.SnRequest.SnBody.QueryProdpool.PageSize = pageSize
	params.SnRequest.SnBody.QueryProdpool.StartTime = startTime
	params.SnRequest.SnBody.QueryProdpool.StartTime = startTime
	params.SnRequest.SnBody.QueryProdpool.EndTime = endTime
	result, err := post(ctx, "suning.sngoods.prodpool.query", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type GoodsDetailReq struct {
	SnRequest struct {
		SnBody struct {
			GetProddetail struct {
				SupplierCode string `json:"supplierCode"`
				SkuId        string `json:"skuId"`
			} `json:"getProddetail"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type GoodsDetailRes struct {
	SnResponseContent struct {
		SnBody struct {
			GetProddetail struct {
				Catalogue []struct {
					CatalogId        string `json:"catalogId"`
					CategoryId       string `json:"categoryId"`
					CategoryLevel    string `json:"categoryLevel"`
					CategoryName     string `json:"categoryName"`
					ParentCategoryId string `json:"parentCategoryId"`
				} `json:"catalogue"`
				Introduction string `json:"introduction"`
				Point        string `json:"point"`
				ProdParams   struct {
					Desc []struct {
						CoreFlag            string `json:"coreFlag"`
						SnparameterCode     string `json:"snparameterCode"`
						SnparameterSequence string `json:"snparameterSequence"`
						SnparameterVal      string `json:"snparameterVal"`
						Snparameterdesc     string `json:"snparameterdesc"`
						SnparametersCode    string `json:"snparametersCode"`
						SnparametersDesc    string `json:"snparametersDesc"`
						Snsequence          string `json:"snsequence"`
					} `json:"desc"`
				} `json:"prodParams"`
				SkuId string `json:"skuId"`
			} `json:"getProddetail"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 获取商品详情
func GetGoodsDetail(ctx context.Context, skuId, supplierCode string) (res GoodsDetailRes, err error) {
	params := GoodsDetailReq{}
	params.SnRequest.SnBody.GetProddetail.SkuId = skuId
	params.SnRequest.SnBody.GetProddetail.SupplierCode = supplierCode
	result, err := post(ctx, "suning.sngoods.proddetail.get", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type GoodsBaseDetailReq struct {
	SnRequest struct {
		SnBody struct {
			GetProdbasicdetail struct {
				SupplierCode string `json:"supplierCode"`
				SkuId        string `json:"skuId"`
			} `json:"getProdbasicdetail"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type GoodsBaseDetailRes struct {
	SnResponseContent struct {
		SnBody struct {
			GetProdbasicdetail struct {
				Image         string `json:"image"`
				BrandName     string `json:"brandName"`
				Length        string `json:"length"`
				CatalogCode   string `json:"catalogCode"`
				Weight        string `json:"weight"`
				BuName        string `json:"buName"`
				CmmdtyModel   string `json:"cmmdtyModel"`
				CatalogName   string `json:"catalogName"`
				Volume        string `json:"volume"`
				SizeAttribute int    `json:"sizeAttribute"`
				ProductArea   string `json:"productArea"`
				BrandId       string `json:"brandId"`
				Name          string `json:"name"`
				Width         string `json:"width"`
				SkuId         string `json:"skuId"`
				Height        string `json:"height"`
			} `json:"getProdbasicdetail"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 获取商品基本信息
func GetGoodsBaseDetail(ctx context.Context, skuId, supplierCode string) (res GoodsBaseDetailRes, err error) {
	params := GoodsBaseDetailReq{}
	params.SnRequest.SnBody.GetProdbasicdetail.SkuId = skuId
	params.SnRequest.SnBody.GetProdbasicdetail.SupplierCode = supplierCode
	result, err := post(ctx, "suning.sngoods.prodbasicdetail.get", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type GoodsDetailImageReq struct {
	SnRequest struct {
		SnBody struct {
			QueryProdimage struct {
				SupplierCode string `json:"supplierCode"`
				SkuId        string `json:"skuId"`
			} `json:"queryProdimage"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type GoodsDetailImageRes struct {
	SnResponseContent struct {
		SnBody struct {
			QueryProdimage struct {
				Urls []struct {
					Path            string `json:"path"`
					PictureLocation string `json:"pictureLocation"`
				} `json:"urls"`
				SkuId string `json:"skuId"`
			} `json:"queryProdimage"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 获取商品图片
func GetGoodsDetailImage(ctx context.Context, skuId, supplierCode string) (res GoodsDetailImageRes, err error) {
	params := GoodsDetailImageReq{}
	params.SnRequest.SnBody.QueryProdimage.SkuId = skuId
	params.SnRequest.SnBody.QueryProdimage.SupplierCode = supplierCode
	result, err := post(ctx, "suning.sngoods.prodimage.query", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type MinOrderSkus struct {
	SupplierCode string `json:"supplierCode"`
	SkuId        string `json:"skuId"`
}

type GoodsMinOrderQuantityReq struct {
	SnRequest struct {
		SnBody struct {
			QueryMinorderquantity struct {
				Skus []*MinOrderSkus `json:"skus"`
			} `json:"queryMinorderquantity"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type GoodsMinOrderQuantityRes struct {
	SnResponseContent struct {
		SnBody struct {
			QueryMinorderquantity struct {
				Skus []struct {
					SupplierCode string `json:"supplierCode"`
					SkuId        string `json:"skuId"`
					MinNum       string `json:"minNum"`
				} `json:"skus"`
			} `json:"queryMinorderquantity"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 查询商品最小起订量
func GetMinOrderQuantity(ctx context.Context, req []*MinOrderSkus) (res GoodsMinOrderQuantityRes, err error) {
	params := GoodsMinOrderQuantityReq{}
	params.SnRequest.SnBody.QueryMinorderquantity.Skus = req
	result, err := post(ctx, "suning.sngoods.minorderquantity.query", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type GoodsPassPartProductInfoReq struct {
	SnRequest struct {
		SnBody struct {
			QueryPasspartproductinfo struct {
				SpuId        string `json:"spuId"`
				SupplierCode string `json:"supplierCode"`
			} `json:"queryPasspartproductinfo"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type GoodsPassPartProductInfoRes struct {
	SnResponseContent struct {
		SnBody struct {
			QueryPasspartproductinfo struct {
				Data struct {
					SpuId        string `json:"spuId"`
					SupplierCode string `json:"supplierCode"`
					ProductList  []struct {
						CharacterValueId          string `json:"characterValueId"`
						ItemName                  string `json:"itemName"`
						CharacterValueDisplayName string `json:"characterValueDisplayName"`
						CharacterId               string `json:"characterId"`
						SkuId                     string `json:"skuId"`
						CharacterDisplayName      string `json:"characterDisplayName"`
					} `json:"productList"`
				} `json:"data"`
			} `json:"queryPasspartproductinfo"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

//获取通子码商品信息
func GetGoodsPassPartProductInfo(ctx context.Context, spuId, supplierCode string) (res GoodsPassPartProductInfoRes, err error) {
	params := GoodsPassPartProductInfoReq{}
	params.SnRequest.SnBody.QueryPasspartproductinfo.SpuId = spuId
	params.SnRequest.SnBody.QueryPasspartproductinfo.SupplierCode = supplierCode
	result, err := post(ctx, "suning.sngoods.passpartproductinfo.query", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
