package suning

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type OrderReturnGoodsSubmitReq struct {
	SnRequest struct {
		SnBody struct {
			AddReturngoodssubmit struct {
				DistrictId    string `json:"districtId"`
				Quantity      string `json:"quantity"`
				OrderItemId   string `json:"orderItemId"`
				Name          string `json:"name"`
				DetailAddress string `json:"detailAddress"`
				LogisticsCode string `json:"logisticsCode"`
				Telephone     string `json:"telephone"`
				CityId        string `json:"cityId"`
				ReasonCode    string `json:"reasonCode"`
				TownId        string `json:"townId"`
				SrvStatus     string `json:"srvStatus"`
				ReturnAmount  string `json:"returnAmount"`
			} `json:"addReturngoodssubmit"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type OrderReturnGoodsSubmitRes struct {
	SnResponseContent struct {
		SnBody struct {
			AddReturngoodssubmit struct {
				OrderItemId string `json:"orderItemId"`
			} `json:"addReturngoodssubmit"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 提交售后服务申请
func OrderReturnGoodsSubmit(ctx context.Context, req *OrderReturnGoodsSubmitReq) (res OrderReturnGoodsSubmitRes, err error) {
	result, err := post(ctx, "suning.sngoods.returngoodssubmit.add", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderReturnCancelReq struct {
	SnRequest struct {
		SnBody struct {
			DeleteCancelapplication struct {
				OrderItemId string `json:"orderItemId"`
			} `json:"deleteCancelapplication"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type OrderReturnCancelRes struct {
	SnResponseContent struct {
		SnBody struct {
			DeleteCancelapplication struct {
				OrderItemId string `json:"orderItemId"`
			} `json:"deleteCancelapplication"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 撤销售后申请
func OrderReturnCancel(ctx context.Context, OrderItemId string) (res OrderReturnCancelRes, err error) {
	req := OrderReturnCancelReq{}
	req.SnRequest.SnBody.DeleteCancelapplication.OrderItemId = OrderItemId
	result, err := post(ctx, "suning.sngoods.cancelapplication.delete", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderReturnExchangeDetailInfoReq struct {
	SnRequest struct {
		SnBody struct {
			QueryExchangedetailinfo struct {
				OrderItemId string `json:"orderItemId"`
			} `json:"queryExchangedetailinfo"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type OrderReturnExchangeDetailInfoRes struct {
	SnResponseContent struct {
		SnBody struct {
			QueryExchangedetailinfo struct {
				ReasonName string `json:"reasonName"`
				Quantity   string `json:"quantity"`
				EventList  []struct {
					UpdateTime    string `json:"updateTime"`
					EventDescribe string `json:"eventDescribe"`
					Desc          string `json:"desc"`
				} `json:"eventList"`
				OrderItemId      string `json:"orderItemId"`
				MainImageUrl     string `json:"mainImageUrl"`
				ReturnType       string `json:"returnType"`
				SkuId            string `json:"skuId"`
				ProductName      string `json:"productName"`
				ReturnAmount     string `json:"returnAmount"`
				ExchangeNodeInfo []struct {
					NodeName   string `json:"nodeName"`
					NodeState  string `json:"nodeState"`
					UpdateTime string `json:"updateTime"`
				} `json:"exchangeNodeInfo"`
			} `json:"queryExchangedetailinfo"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

//售后详情查询
func OrderReturnExchangeDetailInfo(ctx context.Context, OrderItemId string) (res OrderReturnExchangeDetailInfoRes, err error) {
	req := OrderReturnExchangeDetailInfoReq{}
	req.SnRequest.SnBody.QueryExchangedetailinfo.OrderItemId = OrderItemId
	result, err := post(ctx, "suning.sngoods.exchangedetailinfo.query", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderReturnAfterSaleServiceReq struct {
	SnRequest struct {
		SnBody struct {
			QueryAftersaleservice struct {
				OrderItemId string `json:"orderItemId"`
			} `json:"queryAftersaleservice"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type OrderReturnAfterSaleServiceRes struct {
	SnResponseContent struct {
		SnBody struct {
			QueryAftersaleservice struct {
				OrderItemId   string `json:"orderItemId"`
				LogisticsList []struct {
					LogisticsCode string `json:"logisticsCode"`
					LogisticsDesc string `json:"logisticsDesc"`
				} `json:"logisticsList"`
				SrvList []struct {
					ProductRetMoney string `json:"productRetMoney"`
					DeliveryMode    string `json:"deliveryMode"`
					EnjoyMoney      string `json:"enjoyMoney"`
					PermitChgNum    string `json:"permitChgNum"`
					PermitRefStatus string `json:"permitRefStatus"`
					SrvName         string `json:"srvName"`
					PermitRetNum    string `json:"permitRetNum"`
					SrvStatus       string `json:"srvStatus"`
					ReasonList      []struct {
						ReasonName string `json:"reasonName"`
						ReasonCode string `json:"reasonCode"`
					} `json:"reasonList"`
					PermitChgStatus string `json:"permitChgStatus"`
					PermitRetStatus string `json:"permitRetStatus"`
				} `json:"srvList"`
			} `json:"queryAftersaleservice"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

//订单支持售后服务类型查询
func OrderReturnAfterSaleService(ctx context.Context, OrderItemId string) (res OrderReturnAfterSaleServiceRes, err error) {
	req := OrderReturnAfterSaleServiceReq{}
	req.SnRequest.SnBody.QueryAftersaleservice.OrderItemId = OrderItemId
	result, err := post(ctx, "suning.sngoods.aftersaleservice.query", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderReturnCurrentEventOperationReq struct {
	SnRequest struct {
		SnBody struct {
			QueryCurrenteventoperation struct {
				OrderItemId string `json:"orderItemId"`
			} `json:"queryCurrenteventoperation"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type OrderReturnCurrentEventOperationRes struct {
	SnResponseContent struct {
		SnBody struct {
			QueryCurrenteventoperation struct {
				OperationList struct {
					CountdownTime string `json:"countdownTime"`
					ExpressList   []struct {
						ExpressName    string `json:"expressName"`
						Expressid      string `json:"expressid"`
						FirstUpperChar string `json:"firstUpperChar"`
					} `json:"expressList"`
					OperationType string `json:"operationType"`
				} `json:"operationList"`
				OrderItemId string `json:"orderItemId"`
				DisplayList struct {
					ReturnMode           string `json:"returnMode"`
					ReasonAgreen         string `json:"reasonAgreen"`
					ExpressOrderId       string `json:"expressOrderId"`
					ReceiverName         string `json:"receiverName"`
					LogisticsTraceDesc   string `json:"logisticsTraceDesc"`
					ExpressCompanyName   string `json:"expressCompanyName"`
					CourierName          string `json:"courierName"`
					ReceiverPhone        string `json:"receiverPhone"`
					RemarkContent        string `json:"remarkContent"`
					DragTime             string `json:"dragTime"`
					LogisticsTraceTime   string `json:"logisticsTraceTime"`
					ServiceStatus        string `json:"serviceStatus"`
					ReturngoodsAddress   string `json:"returngoodsAddress"`
					CourierPhone         string `json:"courierPhone"`
					PictureCodesSupplier string `json:"pictureCodesSupplier"`
				} `json:"displayList"`
			} `json:"queryCurrenteventoperation"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

//查询当前节点操作及展示信息
func OrderReturnCurrentEventOperation(ctx context.Context, OrderItemId string) (res OrderReturnCurrentEventOperationRes, err error) {
	req := OrderReturnCurrentEventOperationReq{}
	req.SnRequest.SnBody.QueryCurrenteventoperation.OrderItemId = OrderItemId
	result, err := post(ctx, "suning.sngoods.currenteventoperation.query", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderReturnLogNumSubmitReq struct {
	SnRequest struct {
		SnBody struct {
			AddLognumsubmit struct {
				OrderItemId    string `json:"orderItemId"`
				ExpressOrderId string `json:"expressOrderId"`
				Expressid      string `json:"expressid"`
			} `json:"addLognumsubmit"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type OrderReturnLogNumSubmitRes struct {
	SnResponseContent struct {
		SnBody struct {
			AddLognumsubmit struct {
				OrderItemId string `json:"orderItemId"`
			} `json:"addLognumsubmit"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

//提交物流信息
func OrderReturnLogNumSubmit(ctx context.Context, OrderItemId, ExpressOrderId, ExpressId string) (res OrderReturnLogNumSubmitRes, err error) {
	req := OrderReturnLogNumSubmitReq{}
	req.SnRequest.SnBody.AddLognumsubmit.OrderItemId = OrderItemId
	req.SnRequest.SnBody.AddLognumsubmit.ExpressOrderId = ExpressOrderId
	req.SnRequest.SnBody.AddLognumsubmit.Expressid = ExpressId
	result, err := post(ctx, "suning.sngoods.lognumsubmit.add", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OerReturnConfirmGoodsReq struct {
	SnRequest struct {
		SnBody struct {
			AddConfirmgoods struct {
				OrderItemId string `json:"orderItemId"`
			} `json:"addConfirmgoods"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type OerReturnConfirmGoodsRes struct {
	SnResponseContent struct {
		SnBody struct {
			AddConfirmgoods struct {
				OrderItemId string `json:"orderItemId"`
			} `json:"addConfirmgoods"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

//换货确认收货
func OerReturnConfirmGoods(ctx context.Context, OrderItemId string) (res OerReturnConfirmGoodsRes, err error) {
	req := OerReturnConfirmGoodsReq{}
	req.SnRequest.SnBody.AddConfirmgoods.OrderItemId = OrderItemId
	result, err := post(ctx, "suning.sngoods.confirmgoods.add", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
