package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
)

type SpuSaleInfosReq struct {
	DivisionCode string
	PurchaserId  string
	ProductIds   []string
}

type SpuSaleInfosRes struct {
	RequestId        string `json:"requestId"`
	ProductSaleInfos []struct {
		RequestId    interface{} `json:"requestId"`
		ShopId       string      `json:"shopId"`
		DivisionCode string      `json:"divisionCode"`
		ProductId    string      `json:"productId"`
		Title        string      `json:"title"`
		Skus         []struct {
			ShopId        string `json:"shopId"`
			DivisionCode  string `json:"divisionCode"`
			ProductId     string `json:"productId"`
			SkuId         string `json:"skuId"`
			Title         string `json:"title"`
			SkuStatus     string `json:"skuStatus"`
			CanSell       bool   `json:"canSell"`
			Quantity      int    `json:"quantity"`
			FuzzyQuantity string `json:"fuzzyQuantity"`
			Price         int    `json:"price"`
			MarkPrice     int    `json:"markPrice"`
		} `json:"skus"`
		CanSell       bool   `json:"canSell"`
		ProductStatus string `json:"productStatus"`
		Quantity      int    `json:"quantity"`
		FuzzyQuantity string `json:"fuzzyQuantity"`
	} `json:"productSaleInfos"`
}

// SpuSaleInfos 查询选品池商品销售信息
func (s goodsTm) SpuSaleInfos(ctx context.Context, req SpuSaleInfosReq) (res *SpuSaleInfosRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "ListSelectionProductSaleInfos")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	if req.PurchaserId == "" {
		req.PurchaserId = PurchaserId
	}
	Request := &client.ListSelectionProductSaleInfosRequest{}
	var Body = new(client.ProductSaleInfoListQuery)
	Body.SetPurchaserId(req.PurchaserId)

	if req.DivisionCode != "" {
		Body.SetDivisionCode(req.DivisionCode)
	}
	var list []*string
	for _, item := range req.ProductIds {
		list = append(list, tea.String(item))
	}
	Body.SetProductIds(list)
	Request.SetBody(Body)
	r, err := server.ListSelectionProductSaleInfos(Request)
	if err != nil {
		return
	}
	g.Log().Info(r.Body)
	err = gjson.New(r.Body).Scan(&res)
	return
}
