package yonghui

/**
订单数据推送
*/
type OrderPushReq struct {
	CreateTime   string `json:"createTime"`
	FinishTime   string `json:"finishTime"`
	Freight      int    `json:"freight"`
	GoodsDetails []struct {
		ClassCode  string `json:"classCode"`
		ClassName  string `json:"className"`
		GoodsCode  string `json:"goodsCode"`
		GoodsCount int    `json:"goodsCount"`
		GoodsImage string `json:"goodsImage"`
		GoodsName  string `json:"goodsName"`
		GoodsPrice int    `json:"goodsPrice"`
		GoodsSpec  string `json:"goodsSpec"`
		GoodsUnit  string `json:"goodsUnit"`
		NetPrice   int    `json:"netPrice"`
		TaxPrice   int    `json:"taxPrice"`
		TaxRate    int    `json:"taxRate"`
		TotalPrice int    `json:"totalPrice"`
	} `json:"goodsDetails"`
	OrderCode   string `json:"orderCode"`
	OrderPrice  int    `json:"orderPrice"`
	OrderStatus string `json:"orderStatus"`
	OrderType   int    `json:"orderType"`
	PayDetails  []struct {
		PayAmount int    `json:"payAmount"`
		PayCode   string `json:"payCode"`
		PayType   string `json:"payType"`
	} `json:"payDetails"`
	PayTime         string `json:"payTime"`
	PushType        string `json:"pushType"`
	ReceiverAddress string `json:"receiverAddress"`
	ReceiverName    string `json:"receiverName"`
	ReceiverPhone   string `json:"receiverPhone"`
	ShipTime        string `json:"shipTime"`
	SignTime        string `json:"signTime"`
	UserName        string `json:"userName"`
	UserTelephone   string `json:"userTelephone"`
}

type DataPushRes struct {
	Result  bool   `json:"result"`
	Message string `json:"message"`
}

/**
包裹数据推
*/
type PackagePushReq struct {
	GoodsDetails []struct {
		GoodsCode    string `json:"goodsCode"`
		GoodsCount   int    `json:"goodsCount"`
		GoodsName    string `json:"goodsName"`
		LogisticCode string `json:"logisticCode"`
		OutCountSum  int    `json:"outCountSum"`
		PageOutCount int    `json:"pageOutCount"`
		ShipperCode  string `json:"shipperCode"`
	} `json:"goodsDetails"`
	LogisticCode   string `json:"logisticCode"`
	LogisticStatus int    `json:"logisticStatus"`
	LogisticTime   string `json:"logisticTime"`
	OrderCode      string `json:"orderCode"`
	OrderKey       string `json:"orderKey"`
	PackageCode    string `json:"packageCode"`
	PackageRemark  string `json:"packageRemark"`
	PushType       string `json:"pushType"`
	ReceiverName   string `json:"receiverName"`
	ShipperCode    string `json:"shipperCode"`
	ShipperName    string `json:"shipperName"`
	ThirdOrderCode string `json:"thirdOrderCode"`
	UserTelephone  string `json:"userTelephone"`
}
