package yunzmall

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/errors/gerror"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/util/gconv"
)

type TokenGetRes struct {
	Code int `json:"code"`
	Data struct {
		Token     string `json:"token"`
		ExpiresAt int64  `json:"expiresAt"`
	} `json:"data"`
	Msg string `json:"msg"`
}

func (s *Client) GetToken(ctx context.Context) (res *TokenGetRes, err error) {
	var method = "/app/application/getToken"
	result, err := s.post(ctx, method, g.Map{
		"app_key":    s.AppKey,
		"app_secret": s.AppSecret,
	}, true)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	if err != nil {
		return
	}
	return
}

func (s *Client) RefreshToken(ctx context.Context) (res string, err error) {
	var conn = g.Redis().Conn()
	defer func() {
		_ = conn.Close()
	}()
	_, _ = conn.DoVar("SELECT", s.DB)
	var result *TokenGetRes
	result, err = s.GetToken(ctx)
	if err != nil {
		err = gerror.New("获取token失败")
		return
	}
	if result.Code != 0 {
		err = gerror.New("获取token失败")
		return
	}
	res = result.Data.Token
	_, _ = conn.Do("HMSET", CacheKey+gconv.String(s.Source), "Token", result.Data.Token, "ExpiresAt", result.Data.ExpiresAt)
	return
}

type TokenCacheRes struct {
	Token     string
	ExpiresAt int64
}

func (s *Client) AccessToken(ctx context.Context) (res string, err error) {
	var conn = g.Redis().Conn()
	defer func() {
		_ = conn.Close()
	}()
	_, _ = conn.DoVar("SELECT", s.DB)
	cache, _ := conn.DoVar("HGETALL", CacheKey+gconv.String(s.Source))
	if cache.IsEmpty() {
		return s.RefreshToken(ctx)
	}
	var cacheRes *TokenCacheRes
	_ = gjson.New(cache).Scan(&cacheRes)
	if cacheRes.ExpiresAt < gtime.TimestampMilli() {
		return s.RefreshToken(ctx)
	}
	res = cacheRes.Token
	return
}
