package jingdong

import (
	"context"
	"github.com/gogf/gf/container/garray"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type msgJD struct {
}

var Msg = msgJD{}

type GetPushMessages struct {
	CommonRes
	Result []struct {
		Id     int         `json:"id"`
		Type   int         `json:"type"`
		Time   string      `json:"time"`
		Result interface{} `json:"result"`
	} `json:"result"`
}

type DelPushMessages struct {
	CommonRes
	Result bool `json:"result"`
}

//GetPushMessages 获取消息   【每次是能获取100条，旧消息不删除不能获取最新消息】
//1：订单拆分消息{"id":推送id, "result" : {"pOrder" :父订单id} , "type": 1, "time":推送时间}
//2：商品价格变更{"id":推送id, "result":{"skuId" : 商品编号 }, "type": 2, "time":推送时间}
//4：商品上下架变更消息{"id":推送id, "result":{"skuId" : 商品编号 }, "type": 4 "time":推送时间}
//5：订单妥投消息{"id":推送id, "result":{"orderId":"京东订单编号", "state":"1是妥投，2是拒收"}, "type" : 5, "time":推送时间}
//6：商品池内商品添加、删除消息{"id":推送id, "result":{"skuId": 商品编号, "page_num":商品池编号, "state":"1添加，2删除"}, "type" : 6, "time":推送时间}
//10：订单取消消息{"id":推送id, "result":{" orderId": 京东订单编号 }, "type" : 10, "time":推送时间}
//11：发票开票进度消息{"id":推送id, "result":{"markId":"发票提报标识","state":"状态"}, "type" : 11, "time":推送时间}
//state状态：1：代表全部开票；2：代表驳回；3：部分开票；4：发票寄出
//12：配送单生成成功消息{"id":推送id, "result":{" orderId": 京东订单编号 }, "type" : 12, "time":推送时间}
//13：换新订单生成成功消息{"id":推送id, "result":{"afsServiceId": 服务单号, " orderId":换新订单号}, "type" : 13, "time":推送时间}
//14：支付失败消息{"id":推送id, "result":{" orderId": 京东订单编号}, "type" : 14, "time":推送时间}
//15：7天未支付取消消息/未确认取消消息{"id":推送id, "result":{"orderId": 京东订单编号, "cancelType": 取消类型}， "type" : 15, "time":推送时间}
//16：商品介绍及规格参数变更消息{"id":推送id, "result":{"skuId" : 商品编号 } "type" : 16, "time":推送时间}
//17：赠品促销变更消息{"id":推送id, "result":{"skuId" : 商品编号 } "type" : 17, "time":推送时间}
//18：订单等待确认收货消息{"id":推送id, "result":{"orderId":京东订单号} "type" : 18, "time":推送时间}
//23：订单配送退货消息{"id":推送id, "result":{"orderId":京东订单号} "type" : 23, "time":推送时间}
//25：新订单消息{"id":推送id, "result":{"orderId":京东订单号, "pin":"京东账号"} "type" : 25, "time":推送时间(订单创建时间)}
//26：预定订单消息{"id":推送id, "result":{"orderId":京东订单号} "type" : 26, "time":推送时间}
//28：售后服务单进度消息{"id":推送id, "result":{"orderId":京东订单号,"pin":"京东账号","skuId":商品编号,"afsServiceId":"服务单号","state":服务单状态} "type" : 28, "time":推送时间}
//31：订单完成消息{"orderId":123123123,"jdOrderState":19,"completeTime":"2018-09-20 16:21:21","pin":"测试pin"}
//48：商品池添加、删除消息{"id":推送id, "result":"{"poolType": "recommend", "page_num":"商品池编号", "state":"1添加，2删除"}", "type" : 28, "time":推送时间}
//49：折扣率变更消息{"id":推送id, "result":"{"oldRate":0.10,"category":"670-671-718","newRate":0.05,"type":1}" "type" : 28, "time":推送时间}
//50：京东地址变更消息[{ "id": "推送id", "result": { "areaId": "京东地址编码", "areaName": "京东地址名称", "parentId": "父京东ID编码", "areaLevel": “地址等级(行政级别：国家(1)、省(2)、市(3)、县(4)、镇(5))”, "operateType":”操作类型(插入数据为1，更新时为2，删除时为3)}”, "time":"消息推送时间", “type":”消息类型” } ]
//100：商品税率变更消息（目前未涵盖全部商品）{"timestampLong": "1499136371666","features": "consumptionVAT:12,outputVAT:11,inputVAT:11","sku_id": "3213213"}
//102：专票资质审核进度消息  {"completeDate":"2019-01-09 00:19:14","pushDate":"2019-01-09 00:19:16","pins":"测试","reason":"财务审批通过","status":2,"unitName":"广州市翎唯营销策划有限公司","submitDate":"2018-09-25 15:56:47","taxpayerId":"914401055697802911","vatId":462260}
func (*msgJD) GetPushMessages(ctx context.Context, id *garray.Array) (res *GetPushMessages, err error) {
	method := "message/get"
	param := g.Map{
		"type": id.Join(","),
	}
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

//DeletePushMessage 删除消息
func (*msgJD) DeletePushMessage(ctx context.Context, id *garray.Array) (res *DelPushMessages, err error) {
	method := "message/del"
	param := g.Map{
		"id": id.Join(","),
	}
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type MsgSolitRes struct {
	CommonRes
	Result []struct {
		Id     string `json:"id"`
		Time   string `json:"time"`
		Type   int    `json:"type"`
		Result struct {
			POrder string `json:"pOrder"`
		} `json:"result"`
	} `json:"result"`
}

//Solit 拆单
func (*msgJD) Solit(ctx context.Context) (res *MsgSolitRes, err error) {
	method := "message/get"
	param := g.Map{
		"type": "1",
	}
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}
	err = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}

type MsgSendRes struct {
	CommonRes
	Result []struct {
		Id     string `json:"id"`
		Time   string `json:"time"`
		Type   int    `json:"type"`
		Result struct {
			OrderId string `json:"orderId"`
		} `json:"result"`
	} `json:"result"`
}

//Send 发货
func (*msgJD) Send(ctx context.Context) (res *MsgSendRes, err error) {
	method := "message/get"
	param := g.Map{
		"type": "12",
	}
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}
	err = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}

type MsgSuccessRes struct {
	CommonRes
	Result []struct {
		Id     string `json:"id"`
		Time   string `json:"time"`
		Type   int    `json:"type"`
		Result struct {
			JdOrderState int    `json:"jdOrderState"`
			Pin          string `json:"pin"`
			CompleteTime string `json:"completeTime"`
			OrderId      string `json:"orderId"`
		} `json:"result"`
	} `json:"result"`
}

//Success 订单完成
func (*msgJD) Success(ctx context.Context) (res *MsgSuccessRes, err error) {
	method := "message/get"
	param := g.Map{
		"type": "31",
	}
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}
	err = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}

type MsgReplaceRes struct {
	CommonRes
	Result []struct {
		Id     string `json:"id"`
		Time   string `json:"time"`
		Type   int    `json:"type"`
		Result struct {
			AfsServiceId string `json:"afsServiceId"`
			OrderId      string `json:"orderId"`
		} `json:"result"`
	} `json:"result"`
}

//Replace 换新订单
func (*msgJD) Replace(ctx context.Context) (res *MsgReplaceRes, err error) {
	method := "message/get"
	param := g.Map{
		"type": "13",
	}
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}
	err = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}

type MsgRefundRes struct {
	CommonRes
	Result []struct {
		Id     string `json:"id"`
		Time   string `json:"time"`
		Type   int    `json:"type"`
		Result struct {
			Pin          string `json:"pin"`
			AfsServiceId string `json:"afsServiceId"`
			IsOffline    bool   `json:"isOffline"`
			State        int    `json:"state,omitempty"`
			SkuId        string `json:"skuId"`
			OrderId      string `json:"orderId"`
		} `json:"result"`
	} `json:"result"`
}

//Refund 售后
func (*msgJD) Refund(ctx context.Context) (res *MsgRefundRes, err error) {
	method := "message/get"
	param := g.Map{
		"type": "110",
	}
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}
	err = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}
