package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type OrderListReq struct {
	PageNumber      int32
	PageSize        int32
	OrderIdList     []string
	PurchaseOrderId string
}

type OrderListRes struct {
	OrderList []struct {
		OrderAmount   int `json:"orderAmount"`
		OrderLineList []struct {
			ProductTitle    string `json:"productTitle"`
			Number          string `json:"number"`
			SkuTitle        string `json:"skuTitle"`
			ProductId       string `json:"productId"`
			OrderId         string `json:"orderId"`
			ProductPic      string `json:"productPic"`
			OrderLineId     string `json:"orderLineId"`
			LogisticsStatus string `json:"logisticsStatus"`
			PayFee          int    `json:"payFee"`
			SkuId           string `json:"skuId"`
			OrderLineStatus string `json:"orderLineStatus"`
		} `json:"orderLineList"`
		OrderId           string `json:"orderId"`
		DistributorId     string `json:"distributorId"`
		OrderStatus       string `json:"orderStatus"`
		LogisticsStatus   string `json:"logisticsStatus"`
		CreateDate        string `json:"createDate"`
		RequestId         string `json:"requestId"`
		OrderClosedReason string `json:"orderClosedReason"`
	} `json:"orderList"`
	RequestId string `json:"requestId"`
	Total     int    `json:"total"`
}

// List 查询订单列表
func (s orderTm) List(ctx context.Context, req OrderListReq) (res *OrderListRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "QueryOrders")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()

	if req.PageNumber == 0 {
		req.PageNumber = 1
	}
	if req.PageSize == 0 {
		req.PageSize = 10
	}

	Request := &client.QueryOrdersRequest{}
	var Body = new(client.OrderPageQuery)
	Body.SetPageNumber(req.PageNumber)
	Body.SetPageSize(req.PageSize)
	var list []*string
	for _, item := range req.OrderIdList {
		list = append(list, tea.String(item))
	}
	if req.PurchaseOrderId != "" {
		Body.SetPurchaseOrderId(req.PurchaseOrderId)

	}
	if len(list) > 0 {
		Body.SetOrderIdList(list)
	}
	Request.SetBody(Body)

	r, err := server.QueryOrders(Request)
	if err != nil {
		return
	}

	err = gjson.New(r.Body).Scan(&res)
	return
}
