package alibaba

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type orderAli struct {
}

var Order = orderAli{}

type OrderCommonReq struct {
	AddressParam   OrderAddress
	CargoParam     []OrderCargo
	OuterOrderInfo OuterOrderInfo
}

type OrderAddress struct {
	FullName     string `json:"fullName"`
	Mobile       string `json:"mobile"`
	Phone        string `json:"phone"`
	PostCode     string `json:"postCode"`
	CityText     string `json:"cityText"`
	ProvinceText string `json:"provinceText"`
	AreaText     string `json:"areaText"`
	TownText     string `json:"townText"`
	Address      string `json:"address"`
}

type OrderCargo struct {
	SpecId      string `json:"specId"`
	OfferId     int64  `json:"offerId"`
	Quantity    int    `json:"quantity"`
	OutShopCode string `json:"outShopCode"`
	OutItemCode string `json:"outItemCode"`
	Channel     string `json:"channel"`
}

type OuterOrderInfo struct {
	MediaOrderId string       `json:"mediaOrderId"`
	Phone        string       `json:"phone"`
	Offers       []OrderOffer `json:"offers"`
}

type OrderOffer struct {
	SpecId string `json:"specId"`
	Id     int64  `json:"id"`
	Num    int    `json:"num"`
	Price  int64  `json:"price"`
}

type OrderCreateRes struct {
	CommonRes
	Result struct {
		TotalSuccessAmount int64  `json:"totalSuccessAmount"` //下单成功的订单总金额，单位：分
		OrderId            string `json:"orderId"`            //下单成功后的订单id
		PostFee            int64  `json:"postFee"`            //原始运费，单位：分。注意：下单后卖家可能调整，因此该值可能不等于最终支付运费
	} `json:"result,omitempty"`
}

//Create 下单
func (s *orderAli) Create(ctx context.Context, req *OrderCommonReq) (res *OrderCreateRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.fenxiaoOrder.create"
	//添加分销关系
	for k, v := range req.CargoParam {
		req.CargoParam[k].OutShopCode = "1"
		req.CargoParam[k].OutItemCode = gconv.String(v.OfferId)
		req.CargoParam[k].Channel = "other"
	}
	result, err := server.Post(ctx, method, g.Map{
		"access_token":   server.AccessToken,
		"addressParam":   gjson.New(req.AddressParam).MustToJsonString(),
		"cargoParamList": gjson.New(req.CargoParam).MustToJsonString(),
		"outerOrderInfo": gjson.New(req.OuterOrderInfo).MustToJsonString(),
		"flow":           "fenxiao",
		"isvBizTypePD":   "false",
		"isvBizTypeStr":  "fenxiaoMedia",
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type OrderDetailRes struct {
	CommonRes
	Result struct {
		BaseInfo struct {
			PayTime           string  `json:"payTime"`
			Discount          int     `json:"discount"`
			AlipayTradeID     string  `json:"alipayTradeId"`
			SumProductPayment float64 `json:"sumProductPayment"`
			FlowTemplateCode  string  `json:"flowTemplateCode"`
			SellerOrder       bool    `json:"sellerOrder"`
			BuyerLoginID      string  `json:"buyerLoginId"`
			ModifyTime        string  `json:"modifyTime"`
			ID                int64   `json:"id"`
			BuyerContact      struct {
				Phone        string `json:"phone"`
				ImInPlatform string `json:"imInPlatform"`
				Name         string `json:"name"`
				CompanyName  string `json:"companyName"`
			} `json:"buyerContact"`
			SellerLoginID    string  `json:"sellerLoginId"`
			BuyerID          string  `json:"buyerID"`
			CloseOperateType string  `json:"closeOperateType"`
			TotalAmount      float64 `json:"totalAmount"`
			SellerID         string  `json:"sellerID"`
			ShippingFee      float64 `json:"shippingFee"`
			Refund           int     `json:"refund"`
			Status           string  `json:"status"`
			RefundPayment    int     `json:"refundPayment"`
			SellerContact    struct {
				Phone        string `json:"phone"`
				Email        string `json:"email"`
				ImInPlatform string `json:"imInPlatform"`
				Name         string `json:"name"`
				Mobile       string `json:"mobile"`
				CompanyName  string `json:"companyName"`
			} `json:"sellerContact"`
			CouponFee    int `json:"couponFee"`
			ReceiverInfo struct {
				ToFullName     string `json:"toFullName"`
				ToDivisionCode string `json:"toDivisionCode"`
				ToMobile       string `json:"toMobile"`
				ToPhone        string `json:"toPhone"`
				ToPost         string `json:"toPost"`
				ToArea         string `json:"toArea"`
			} `json:"receiverInfo"`
			TradeType      string   `json:"tradeType"`
			IDOfStr        string   `json:"idOfStr"`
			StepPayAll     bool     `json:"stepPayAll"`
			CreateTime     string   `json:"createTime"`
			BusinessType   string   `json:"businessType"`
			OverSeaOrder   bool     `json:"overSeaOrder"`
			TradeTypeDesc  string   `json:"tradeTypeDesc"`
			PayChannelList []string `json:"payChannelList"`
			TradeTypeCode  string   `json:"tradeTypeCode"`
			PayTimeout     int      `json:"payTimeout"`
			PayTimeoutType int      `json:"payTimeoutType"`
		} `json:"baseInfo"`
		OrderBizInfo struct {
			OdsCyd      bool `json:"odsCyd"`
			CreditOrder bool `json:"creditOrder"`
		} `json:"orderBizInfo"`
		TradeTerms []struct {
			Phase         int64   `json:"phase"`
			PayWayDesc    string  `json:"payWayDesc"`
			ExpressPay    bool    `json:"expressPay"`
			PayTime       string  `json:"payTime"`
			PayStatusDesc string  `json:"payStatusDesc"`
			PayWay        string  `json:"payWay"`
			CardPay       bool    `json:"cardPay"`
			PayStatus     string  `json:"payStatus"`
			PhasAmount    float64 `json:"phasAmount"`
		} `json:"tradeTerms"`
		ProductItems []struct {
			ItemAmount         float64  `json:"itemAmount"`
			Name               string   `json:"name"`
			Price              float64  `json:"price"`
			ProductID          int64    `json:"productID"`
			ProductImgURL      []string `json:"productImgUrl"`
			ProductSnapshotURL string   `json:"productSnapshotUrl"`
			Quantity           int      `json:"quantity"`
			Refund             int      `json:"refund"`
			SkuID              int64    `json:"skuID"`
			Status             string   `json:"status"`
			SubItemID          int64    `json:"subItemID"`
			Type               string   `json:"type"`
			Unit               string   `json:"unit"`
			GuaranteesTerms    []struct {
				AssuranceInfo        string `json:"assuranceInfo"`
				AssuranceType        string `json:"assuranceType"`
				QualityAssuranceType string `json:"qualityAssuranceType"`
			} `json:"guaranteesTerms"`
			ProductCargoNumber string `json:"productCargoNumber"`
			SkuInfos           []struct {
				Name  string `json:"name"`
				Value string `json:"value"`
			} `json:"skuInfos"`
			EntryDiscount    int    `json:"entryDiscount"`
			SpecID           string `json:"specId"`
			QuantityFactor   int    `json:"quantityFactor"`
			StatusStr        string `json:"statusStr"`
			LogisticsStatus  int    `json:"logisticsStatus"`
			GmtCreate        string `json:"gmtCreate"`
			GmtModified      string `json:"gmtModified"`
			GmtPayExpireTime string `json:"gmtPayExpireTime"`
			SubItemIDString  string `json:"subItemIDString"`
		} `json:"productItems"`
		NativeLogistics struct {
			Address       string `json:"address"`
			Area          string `json:"area"`
			AreaCode      string `json:"areaCode"`
			City          string `json:"city"`
			ContactPerson string `json:"contactPerson"`
			Mobile        string `json:"mobile"`
			Province      string `json:"province"`
			Telephone     string `json:"telephone"`
			Zip           string `json:"zip"`
		} `json:"nativeLogistics"`
		GuaranteesTerms struct {
			AssuranceInfo        string `json:"assuranceInfo"`
			AssuranceType        string `json:"assuranceType"`
			QualityAssuranceType string `json:"qualityAssuranceType"`
		} `json:"guaranteesTerms"`
		OrderRateInfo struct {
			BuyerRateStatus  int `json:"buyerRateStatus"`
			SellerRateStatus int `json:"sellerRateStatus"`
		} `json:"orderRateInfo"`
		ExtAttributes []interface{} `json:"extAttributes"`
	} `json:"result"`
}

//Detail 订单详情
func (s *orderAli) Detail(ctx context.Context, orderSn string) (res *OrderDetailRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.get.buyerView"

	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"webSite":      WebSite,
		"orderId":      orderSn,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

//Pay  支付
func (s *orderAli) Pay(ctx context.Context, orderSn string) (res *CommonRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.pay.protocolPay.preparePay"

	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"tradeWithholdPreparePayParam":gjson.New(g.Map{"orderId":orderSn}).MustToJsonString(),
	})
	_ = gjson.New(result).Scan(&res)

	return
}


type OrderBeforeRes struct {
	CommonRes
	OrderPreviewResuslt []OrderBeforeItem `json:"orderPreviewResuslt"`
}

type OrderBeforeItem struct {
	SumPayment           int64 `json:"sumPayment"`           //订单总费用, 单位为分
	SumPaymentNoCarriage int64 `json:"sumPaymentNoCarriage"` //不包含运费的货品总费用, 单位为分.
	SumCarriage          int64 `json:"sumCarriage"`          //总运费信息, 单位为分.
	Status               bool  `json:"status"`               //
	ShopPromotionList    []struct { //可用店铺级别优惠列表
		PromotionId int64 `json:"promotionId"` //优惠券ID
	} `json:"shopPromotionList"`      //规格信息
	Message   string `json:"message"` //返回信息
	CargoList []struct {
		FinalUnitPrice float64 `json:"finalUnitPrice"` //最终单价
		SpecId         string  `json:"specId"`         //规格ID，offer内唯一
		OfferId        string  `json:"offerId"`        //商品ID
		SkuId          int64   `json:"skuId"`          //规格ID
	} `json:"cargoList"` //规格信息
}

//Before 验证订单商品
func (s *orderAli) Before(ctx context.Context, req *OrderCommonReq) (res *OrderBeforeRes, err error) {
	method := "com.alibaba.trade/alibaba.createOrder.preview"

	//添加分销关系
	for k, v := range req.CargoParam {
		req.CargoParam[k].OutShopCode = "1"
		req.CargoParam[k].OutItemCode = gconv.String(v.OfferId)
		req.CargoParam[k].Channel = "other"
	}

	result, err := server.Post(ctx, method, g.Map{
		"access_token":   server.AccessToken,
		"addressParam":   gjson.New(req.AddressParam).MustToJsonString(),
		"cargoParamList": gjson.New(req.CargoParam).MustToJsonString(),
		"flow":           "saleproxy",
	})
	_ = gjson.New(result).Scan(&res)
	return
}
