package hcw

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type AddressReq struct {
	Source     string `json:"source"`      //渠道（aux，midea，suning）
	Code       string `json:"code"`        //地址编码/上级地址编码
	RegionType string `json:"region_type"` //地址类型source为aux时必传（1-一级地址、2-二级地址、3-三级地址、4-四级地址）
}

type AddressRes struct {
	Id    string `json:"id"`
	Level string `json:"level"`
	Name  string `json:"name"`
	PId   string `json:"pId"`
	SnId  string `json:"snId"`
}

func (s *HcwClient) Address(ctx context.Context, req *AddressReq) (res []*AddressRes, err error) {
	var method = "/address"
	result, err := s.get(ctx, method, req)
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
