package tm

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type goodsTm struct {
}

var Goods = goodsTm{}

type GoodsInventoryReq struct {
	ItemId    string   `json:"ItemId"`
	SkuIdList []string `json:"SkuIdList"`
}

type GoodsInventoryRes struct {
	Code      string `json:"Code"`
	Success   bool   `json:"Success"`
	Message   string `json:"Message"`
	RequestId string `json:"RequestId"`
	ItemList  struct {
		Item []struct {
			ItemId  int `json:"ItemId"`
			SkuList struct {
				Sku []struct {
					SkuId     int `json:"SkuId"`
					Inventory struct {
						Quantity int `json:"Quantity"`
					} `json:"Inventory"`
				} `json:"Sku"`
			} `json:"SkuList"`
		} `json:"Item"`
	} `json:"ItemList"`
}

//Inventory 查询库存
func (s *goodsTm) Inventory(ctx context.Context, DivisionCode string, req []GoodsInventoryReq) (res *GoodsInventoryRes, err error) {
	method := "queryItemInventory"
	request := convert("ItemList", gconv.Maps(req))
	request["DivisionCode"] = DivisionCode
	result, err := post(ctx, method, request)

	_ = json.Unmarshal([]byte(result), &res)
	return
}

type GoodsDetailRes struct {
	Code      string `json:"Code"`
	Success   bool   `json:"Success"`
	Message   string `json:"Message"`
	RequestId string `json:"RequestId"`
	Item      struct {
		ItemId            int                 `json:"ItemId"`
		ItemTitle         string              `json:"ItemTitle"`
		CanSell           bool                `json:"IsCanSell"`
		ReservePrice      int                 `json:"ReservePrice"` //
		Quantity          int                 `json:"Quantity"`
		MinPrice          int                 `json:"MinPrice"`
		TotalSoldQuantity int                 `json:"TotalSoldQuantity"` //销量
		DescOption        string              `json:"DescOption"`
		SellerId          int                 `json:"SellerId"`
		CategoryId        int                 `json:"CategoryId"`
		MainPicUrl        string              `json:"MainPicUrl"`
		TbShopName        string              `json:"TbShopName"`
		SellerPayPostfee  bool                `json:"SellerPayPostfee"` //是否包邮
		PropertiesJson    string              `json:"PropertiesJson"`   //属性
		Properties        map[string][]string `json:"Properties"`       //属性
		Skus              struct {
			Sku []struct {
				ItemId            int               `json:"ItemId"`
				Quantity          int               `json:"Quantity"`
				ReservePrice      int               `json:"ReservePrice"`
				CanSell           bool              `json:"CanSell"`
				SkuId             int               `json:"SkuId"`
				PriceCent         int               `json:"PriceCent"` //售价
				SkuProperties     map[string]string `json:"SkuProperties"`
				SkuPropertiesJson string            `json:"SkuPropertiesJson"`
				SkuPicUrl         string            `json:"SkuPicUrl"`
			} `json:"Sku"`
		} `json:"Skus"`
		ItemImages struct {
			ItemImage []string `json:"ItemImage"`
		} `json:"ItemImages"`
	} `json:"Item"`
}

//Detail 详情
func (*goodsTm) Detail(ctx context.Context, req interface{}) (res *GoodsDetailRes, err error) {
	method := "QueryItemDetail"
	request := g.MapStrStr{
		"ItemId": gconv.String(req),
	}
	result, err := post(ctx, method, request)

	_ = json.Unmarshal([]byte(result), &res)
	return
}
