package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type categoryTm struct {
}

var Category = categoryTm{}

type CategoryListReq struct {
	ParentId    int64
	CategoryIds []int64
}

type CategoryListRes struct {
	Categories []struct {
		CategoryId int    `json:"categoryId"`
		IsLeaf     bool   `json:"isLeaf"`
		Level      int    `json:"level"`
		Name       string `json:"name"`
		ParentId   int    `json:"parentId"`
	} `json:"categories"`
	RequestId string `json:"requestId"`
}

func (s categoryTm) List(ctx context.Context, req CategoryListReq) (res *CategoryListRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "ListCategories")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	Request := &client.ListCategoriesRequest{}
	var Body = new(client.CategoryListQuery)
	if req.ParentId != 0 {
		Body.SetParentCategoryId(req.ParentId)
	}

	var list []*int64
	for _, item := range req.CategoryIds {
		list = append(list, tea.Int64(item))
	}
	Body.SetCategoryIds(list)
	Request.SetBody(Body)

	r, err := server.ListCategories(Request)
	if err != nil {
		return
	}
	//
	err = gjson.New(r.Body).Scan(&res)
	return
}
