package wangdiantong

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type ShopListReq struct {
	IsDisabled  string `json:"is_disabled"`
	PlatformIds string `json:"platform_ids"`
	ShopNo      string `json:"shop_no"`
	PlatformId  string `json:"platform_id"`
	PageSize    int    `json:"page_size"`
	PageNo      int    `json:"page_no"`
}

type ShopListRes struct {
	Code       string `json:"code"`
	TotalCount string `json:"total_count"`
	Shoplist   []struct {
		PlatformId    string `json:"platform_id"`
		SubPlatformId string `json:"sub_platform_id"`
		ShopId        string `json:"shop_id"`
		ShopNo        string `json:"shop_no"`
		ShopName      string `json:"shop_name"`
		AccountId     string `json:"account_id"`
		AccountNick   string `json:"account_nick"`
		Province      string `json:"province"`
		City          string `json:"city"`
		District      string `json:"district"`
		Address       string `json:"address"`
		Contact       string `json:"contact"`
		Zip           string `json:"zip"`
		Mobile        string `json:"mobile"`
		Telno         string `json:"telno"`
		Remark        string `json:"remark"`
	} `json:"shoplist"`
}

func (s *WangDianTong) ShopList(ctx context.Context, req *ShopListReq) (res *ShopListRes, err error) {

	result, err := s.post(ctx, "/openapi2/shop.php", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
