package dwd

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

//售后
type refundDwd struct {
}

var Refund = refundDwd{}

type RefundApplyReq struct {
	OrderID    int64  `json:"order_id"`
	Money      int64  `json:"refund_money"`
	Pics       string `json:"pics,omitempty"`
	ReasonID   int    `json:"reason_id"`
	ReasonDesc string `json:"refund_reason_detail"`
}

type RefundApplyRes struct {
	Errno     int              `json:"errno"`
	Errmsg    string           `json:"errmsg"`
	Data      *RefundApplyData `json:"data"`
	RequestId string           `json:"request_id"`
	Timestamp int              `json:"timestamp"`
	Signature string           `json:"signature"`
}
type RefundApplyData struct {
	BatchNo       string `json:"batch_no"`
	OrderId       int64  `json:"order_id"`
	RefundOrderId int64  `json:"refund_order_id"`
}

//Apply 申请退款
func (*refundDwd) Apply(ctx context.Context, req RefundApplyReq) (res *RefundApplyRes, err error) {
	var method = "refund.apply"
	result, err := post(ctx, method, req)
	if err != nil {
		return
	}
	res = &RefundApplyRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}

type RefundArbitrateReq struct {
	OrderId       string `json:"order_id"`
	RefundOrderId int64  `json:"refund_order_id"`
}

type RefundArbitrateRes struct {
	Errno     int                  `json:"errno"`
	Errmsg    string               `json:"errmsg"`
	Data      *RefundArbitrateData `json:"data"`
	RequestId string               `json:"request_id"`
	Timestamp int                  `json:"timestamp"`
	Signature string               `json:"signature"`
}

type RefundArbitrateData struct {
	BatchNo       string `json:"batch_no"`
	OrderId       int    `json:"order_id"`
	RefundOrderId int    `json:"refund_order_id"`
}

//Arbitrate 申述
func (*refundDwd) Arbitrate(ctx context.Context, req RefundArbitrateReq) (res *RefundArbitrateRes, err error) {
	var method = "refund.arbitrate"
	result, err := post(ctx, method, req)
	if err != nil {
		return
	}
	res = &RefundArbitrateRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}

type RefundDetailRes struct {
	Errno     int               `json:"errno"`
	Errmsg    string            `json:"errmsg"`
	Data      *RefundDetailData `json:"data"`
	RequestId string            `json:"request_id"`
	Timestamp int               `json:"timestamp"`
	Signature string            `json:"signature"`
}

type RefundDetailData struct {
	BatchNo       string `json:"batch_no"`        //订单所属批次号
	OrderId       int64  `json:"order_id"`        //订单id
	RefundOrderId int    `json:"refund_order_id"` //退款单号
	RefundStatus  int    `json:"refund_status"`   //当前退款状态( 1:退款中 2:退款成功 3:退款失败)
	Type          int    `json:"type"`            //类型(1:退款：2:申诉)
	Address       string `json:"address"`         //退货发货地址信息（含联系人、联系电话、地址）,以英文逗号分隔
	Remarks       string `json:"remarks"`         //退款说明（退款状态为“退款失败”时填写的原因）
	RefundMoney   int    `json:"refund_money"`
	AuditStatus   int    `json:"audit_status"` //审核状态: 1.未审核 2.审核通过 3.审核拒绝
	AuditTime     int    `json:"audit_time"`
}

//Detail 详情
func (*refundDwd) Detail(ctx context.Context, OrderID interface{}) (res *RefundDetailRes, err error) {
	var method = "refund.info"
	result, err := post(ctx, method, g.Map{
		"order_id": gconv.Int64(OrderID),
	})
	if err != nil {
		return
	}
	res = &RefundDetailRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}
