package tm

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type category struct {
}

var Category = category{}

type CategoryDetailRes struct {
	Code         string `json:"Code"` //成功 0000
	Message      string `json:"Message"`
	RequestId    string `json:"RequestId"`
	CategoryList []struct {
		CategoryId int    `json:"CategoryId"`
		Name       string `json:"Name"`
	} `json:"CategoryList"`
}

func (category) Detail(ctx context.Context, req string) (res *CategoryDetailRes, err error) {
	method := "GetCategoryChain"

	request := map[string]string{
		"BizUid":     server.BizUid,
		"CategoryId": req,
	}

	result, err := post(ctx, method, request)
	err = gjson.New(result).Scan(&res)
	return
}

type CategoryListRes struct {
	Code         string `json:"Code"` //成功 0000
	Message      string `json:"Message"`
	RequestId    string `json:"RequestId"`
	CategoryList struct {
		Category []struct {
			CategoryId int    `json:"CategoryId"`
			Name       string `json:"Name"`
		} `json:"Category"`
	} `json:"CategoryList"`
}

func (category) List(ctx context.Context, req string) (res *CategoryListRes, err error) {
	method := "GetCategoryList"

	request := map[string]string{
		"CategoryId": req,
	}

	result, err := post(ctx, method, request)
	err = gjson.New(result).Scan(&res)
	return
}
