package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type GoodsListReq struct {
	PageNumber  int32
	PageSize    int32
	PurchaserId string
}

type GoodsListRes struct {
	PageNumber int `json:"pageNumber"`
	PageSize   int `json:"pageSize"`
	Products   []struct {
		BrandName     string `json:"brandName"`
		CanSell       bool   `json:"canSell"`
		CategoryChain []struct {
			CategoryId int    `json:"categoryId"`
			IsLeaf     bool   `json:"isLeaf"`
			Level      int    `json:"level"`
			Name       string `json:"name"`
			ParentId   int    `json:"parentId"`
		} `json:"categoryChain"`
		CategoryLeafId int      `json:"categoryLeafId"`
		DescPath       string   `json:"descPath"`
		FuzzyQuantity  string   `json:"fuzzyQuantity"`
		Images         []string `json:"images"`
		LmItemId       string   `json:"lmItemId"`
		PicUrl         string   `json:"picUrl"`
		ProductId      string   `json:"productId"`
		ProductSpecs   []struct {
			Key    string `json:"key"`
			KeyId  int    `json:"keyId"`
			Values []struct {
				Value   string `json:"value"`
				ValueId int64  `json:"valueId"`
			} `json:"values"`
		} `json:"productSpecs,omitempty"`
		ProductStatus string `json:"productStatus"`
		ProductType   string `json:"productType"`
		Properties    []struct {
			Text   string   `json:"text"`
			Values []string `json:"values"`
		} `json:"properties"`
		Quantity int    `json:"quantity"`
		ShopId   string `json:"shopId"`
		Skus     []struct {
			CanSell       bool   `json:"canSell"`
			FuzzyQuantity string `json:"fuzzyQuantity"`
			MarkPrice     int    `json:"markPrice"`
			PlatformPrice int    `json:"platformPrice"`
			Price         int    `json:"price"`
			ProductId     string `json:"productId"`
			Quantity      int    `json:"quantity"`
			RankValue     int    `json:"rankValue"`
			ShopId        string `json:"shopId"`
			SkuId         string `json:"skuId"`
			SkuSpecs      []struct {
				Key     string `json:"key"`
				KeyId   int    `json:"keyId"`
				Value   string `json:"value"`
				ValueId int64  `json:"valueId"`
			} `json:"skuSpecs"`
			SkuSpecsCode string `json:"skuSpecsCode"`
			SkuStatus    string `json:"skuStatus"`
			Title        string `json:"title"`
			PicUrl       string `json:"picUrl,omitempty"`
			Barcode      string `json:"barcode,omitempty"`
		} `json:"skus"`
		SoldQuantity     string `json:"soldQuantity"`
		TaxCode          string `json:"taxCode"`
		TaxRate          int    `json:"taxRate"`
		Title            string `json:"title"`
		ExtendProperties []struct {
			Key   string `json:"key"`
			Value string `json:"value"`
		} `json:"extendProperties,omitempty"`
	} `json:"products"`
	RequestId string `json:"requestId"`
	Total     int    `json:"total"`
}

// List 查询选品池商品列表
func (s goodsTm) List(ctx context.Context, req GoodsListReq) (res *GoodsListRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "ListSelectionProducts")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	if req.PageNumber == 0 {
		req.PageNumber = 1
	}
	if req.PageSize == 0 {
		req.PageSize = 10
	}
	if req.PurchaserId == "" {
		req.PurchaserId = PurchaserId
	}
	Request := &client.ListSelectionProductsRequest{
		PageNumber:  tea.Int32(req.PageNumber),
		PageSize:    tea.Int32(req.PageSize),
		PurchaserId: tea.String(req.PurchaserId),
	}
	r, err := server.ListSelectionProducts(Request)
	if err != nil {
		return
	}
	err = gjson.New(r.Body).Scan(&res)
	return
}
