package hcw

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type RefundCreateReq struct {
	RefundOrderNo         string   `json:"refund_order_no"`
	OrderSn               string   `json:"order_sn"`
	RefundType            int      `json:"refund_type"`
	RefundReason          string   `json:"refund_reason"`
	RefundReasonType      int      `json:"refund_reason_type"`
	RefundRemark          string   `json:"refund_remark"`
	RefundAddressMerchant string   `json:"refund_address_merchant"`
	RefundVoucher         []string `json:"refund_voucher"`
	RefundPrice           int      `json:"refund_price"`
	RefundGoods           struct {
		OrderGoodsCode string `json:"order_product_no"`
		RefundGoodsNum int    `json:"refund_product_num"`
	} `json:"refund_product"`
	Source string `json:"source"`
}

type RefundCreateRes struct {
	Code    int         `json:"code"`
	Message string      `json:"message"`
	Data    interface{} `json:"data"`
}

func (s *HcwClient) OrderRefundCreate(ctx context.Context, req *RefundCreateReq) (res *RefundCreateRes, err error) {
	var method = "/api/v1/orderRefund"
	result, err := s.post(ctx, method, req)
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

type OrderRefundDetailReq struct {
	RefundNo string `json:"refundNo"` //条数
	Source   string `json:"source"`   //商品来源
}

type OrderRefundDetailRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Data    struct {
		RefundId              int         `json:"refund_id"`
		OrderSn               string      `json:"order_sn"`
		RefundOrderNo         string      `json:"refund_order_no"`
		ThirdRefundOrderNo    string      `json:"third_refund_order_no"`
		RefundPrice           int         `json:"refund_price"`
		RefundApplyTime       string      `json:"refund_apply_time"`
		RefundFinishTime      interface{} `json:"refund_finish_time"`
		RefundType            int         `json:"refund_type"`
		RefundStatus          int         `json:"refund_status"`
		RefundAuditStatus     int         `json:"refund_audit_status"`
		RefundFailMsg         interface{} `json:"refund_fail_msg"`
		RefundReasonType      int         `json:"refund_reason_type"`
		RefundReason          string      `json:"refund_reason"`
		RefundRemark          string      `json:"refund_remark"`
		RefundAddressMerchant string      `json:"refund_address_merchant"`
		FreightDeduction      string      `json:"freight_deduction"`
		RefundVoucher         interface{} `json:"refund_voucher"`
		Source                string      `json:"source"`
		CreatedAt             string      `json:"created_at"`
		UpdatedAt             string      `json:"updated_at"`
		DeletedAt             interface{} `json:"deleted_at"`
		OrderRefundGoods      struct {
			Id                         int    `json:"id"`
			OrderSn                    string `json:"order_sn"`
			RefundOrderNo              string `json:"refund_order_no"`
			OrderProductNo             string `json:"order_product_no"`
			RefundProductName          string `json:"refund_product_name"`
			RefundProductImage         string `json:"refund_product_image"`
			RefundProductNum           int    `json:"refund_product_num"`
			RefundProductOriginalPrice int    `json:"refund_product_original_price"`
			RefundProductPrice         int    `json:"refund_product_price"`
			RefundRemark               string `json:"refund_remark"`
		} `json:"order_refund_goods"`
		OrderRefundLogistics interface{} `json:"order_refund_logistics"`
	} `json:"data"`
}

/*
*退款详情
 */
func (s *HcwClient) OrderRefundDetail(ctx context.Context, req *OrderRefundDetailReq) (res *OrderRefundDetailRes, err error) {
	var method = "/api/v1/orderRefund/" + req.RefundNo + "/" + req.Source
	result, err := s.get(ctx, method, req)
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

type OrderRefundDeliveryNoticeRes struct {
	Code    int         `json:"code"`
	Message string      `json:"message"`
	Data    interface{} `json:"data"`
}

/*
*物流回传
 */
func (s *HcwClient) OrderRefundDeliveryNotice(ctx context.Context, req *OrderRefundDetailReq) (res *OrderRefundDeliveryNoticeRes, err error) {

	var method = "/api/v1/orderRefund/delivery/" + req.RefundNo + "/" + req.Source
	result, err := s.post(ctx, method, req)
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
