package schl

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/util/gconv"
)

type GoodsListReq struct {
	Current int            `json:"current,omitempty"`
	Size    int            `json:"size,omitempty"`
	Query   GoodsListQuery `json:"query"`
}

type GoodsListQuery struct {
	QueryType   int    `json:"queryType"`                //1：全量商品查询		2：选品库商品查询
	GoodsIds    []int  `json:"goodsIds,omitempty"`       //商品id数组，长度最大为100
	GoodsCode   string `json:"goodsCode,omitempty"`      //商品规格编码
	CategoryId1 int    `json:"categoryId,omitempty"`     //商品分类id
	CategoryId2 int    `json:"twoCategoryId,omitempty"`  //二级分类id
	CategoryId3 int    `json:"treeCategoryId,omitempty"` //二级分类id
}

type GoodsListRes struct {
	CommonRes
	Result struct {
		Current int             `json:"current"`
		Total   int             `json:"total"`
		Records []GoodsListItem `json:"records"`
	} `json:"result"`
}

type GoodsListItem struct {
	Id                int                 `json:"id"`
	Title             string              `json:"title"`
	MainImg           string              `json:"mainImg"`
	State             int                 `json:"state"`
	GoodsCategoryList []GoodsListCategory `json:"goodsCategoryList"`
	SpecificationList []GoodsListSpec     `json:"specificationList"`
}

type GoodsListCategory struct {
	C1 int `json:"c1"`
	C2 int `json:"c2"`
	C3 int `json:"c3"`
}

type GoodsListSpec struct {
	Code              string   `json:"code"`
	Name              string   `json:"name"`
	GoodsId           int      `json:"goodsId"`
	SpecInfo          string   `json:"specInfo"`
	CurrVipPrice      float64  `json:"currVipPrice"`
	ItemMainImg       string   `json:"itemMainImg"`
	Imgs              []string `json:"imgs"`
	DetailImgs        []string `json:"detailImgs"`
	Video             string   `json:"video"`
	ForbidBuyArea     string   `json:"forbidBuyArea"`
	IsFreeDelivery    int      `json:"isFreeDelivery"`
	RemoteAreaFreight string   `json:"remoteAreaFreight"`
	MarketIcon        string   `json:"marketIcon"`
	MarketPrice       float64  `json:"marketPrice"`
	MinBuyNum         int      `json:"minBuyNum"`
	StepNum           int      `json:"stepNum"`
	StockNum          int      `json:"stockNum"`
	Weight            float64  `json:"weight"`
	Volume            float64  `json:"volume"`
	Unit              string   `json:"unit"`
	JumpLink          string   `json:"jumpLink"`
	TaxCode           string   `json:"taxCode"`
	BillingName       string   `json:"billingName"`
	BillingSpecName   string   `json:"billingSpecName"`
	ZpTaxRate         string   `json:"zpTaxRate"`
	Freight           float64  `json:"freight"`
}

func (s *Config) GoodsList(ctx context.Context, req GoodsListReq) (res *GoodsListRes, err error) {

	result, err := s.Post(ctx, "/open/xdxt/api/v2/goods/listGoods", gconv.Map(req))
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
