package tm

import (
	"context"
	"encoding/json"
	link "github.com/alibabacloud-go/linkedmall-20220531/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
)

type logisticsTmNew struct {
}

var Logistics = logisticsTmNew{}

type LogisticsTraceRes struct {
	Code      string `json:"Code"`
	Message   string `json:"Message"`
	RequestId string `json:"RequestId"`
	Model []struct{
		MailNo               string `json:"MailNo"`
		DataProvIDer         string `json:"DataProvIDer"`
		DataProvIDerTitle    string `json:"DataProvIDerTitle"`
		LogisticsCompanyCode string `json:"LogisticsCompanyCode"`
		LogisticsCompanyName string `json:"LogisticsCompanyName"`
		LogisticsDetailList  []struct {
			OcurrTimeStr string `json:"OcurrTimeStr"`
			StanderdDesc string `json:"StanderdDesc"`
		} `json:"LogisticsDetailList"`
		Goods []struct {
			GoodName string      `json:"GoodName"`
			Quantity interface{} `json:"Quantity"`
			ItemID   string      `json:"ItemID"`
		} `json:"Goods"`
	} `json:"Model"`
}

//Trace 物流查询接口
func (s *logisticsTmNew) QueryLogistics4Distribution(ctx context.Context,orderSn string) (res *LogisticsTraceRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}
	result ,err :=client.QueryLogistics4Distribution(&link.QueryLogistics4DistributionRequest{
		DistributorId:           tea.String(server.DistributorId),
		MainDistributionOrderId:  tea.String(orderSn),
		TenantId:                tea.String(server.TenantId),
	})


	if result==nil{
		return
	}
	log(ctx,gjson.New(orderSn).MustToJsonString(),result.Body,err)
	if err!=nil{
		return
	}
	a,_:=json.Marshal(result.Body)
	err =json.Unmarshal([]byte(a),&res)

	return
}