package yonghui

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

var Coupons = new(coupons)

type coupons struct {
}

type ExchangeCouponsReq struct {
	RequestId  string `json:"request_id"`
	CouponCode string `json:"coupon_code"`
	Telephone  string `json:"telephone"`
}

type ExchangeCouponsRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    string `json:"data"`
}

/**
优惠券兑换
*/
func (s *coupons) Exchange(ctx context.Context, req *ExchangeCouponsReq) (res *ExchangeCouponsRes, err error) {
	result, err := post(ctx, "com.csx.voucher-exchange-coupons.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type CouponsDetailReq struct {
	CouponId string `json:"coupon_id"`
}

type CouponsDetailRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    struct {
		CouponsId    string `json:"couponsId"`
		Telephone    string `json:"telephone"`
		CouponStatus int    `json:"couponStatus"`
		ExpireDate   string `json:"expireDate"`
	} `json:"data"`
}

/**
优惠券使用明细查询
*/
func (s *coupons) Detail(ctx context.Context, req *CouponsDetailReq) (res *CouponsDetailRes, err error) {
	result, err := post(ctx, "com.csx.voucher-coupons-detail-search.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
