package yz

type MsgOrder struct {
	Msg struct {
		DeliveryOrder []struct {
			PkId         string `json:"pk_id"`
			ExpressState string `json:"express_state"`
			Oids         []struct {
				Oid string `json:"oid"`
			} `json:"oids"`
			ExpressType string `json:"express_type"`
		} `json:"delivery_order"`
		OrderPromotion struct {
			Item []struct {
				Promotions struct {
					PromotionType     string `json:"promotion_type"`
					PromotionTitle    string `json:"promotion_title"`
					PromotionTypeName string `json:"promotion_type_name"`
					PromotionTypeId   string `json:"promotion_type_id"`
					Decrease          string `json:"decrease"`
				} `json:"promotions"`
				IsPresent string `json:"is_present"`
				ItemId    string `json:"item_id"`
				SkuId     string `json:"sku_id"`
				Oid       string `json:"oid"`
			} `json:"item"`
			OrderDiscountFee string `json:"order_discount_fee"`
			AdjustFee        string `json:"adjust_fee"`
			ItemDiscountFee  string `json:"item_discount_fee"`
			Order            []struct {
				PromotionType      string `json:"promotion_type"`
				SubPromotionType   string `json:"sub_promotion_type"`
				CouponId           string `json:"coupon_id"`
				PromotionTitle     string `json:"promotion_title"`
				PromotionCondition string `json:"promotion_condition"`
				PromotionTypeName  string `json:"promotion_type_name"`
				PromotionContent   string `json:"promotion_content"`
				PromotionId        string `json:"promotion_id"`
				PromotionTypeId    string `json:"promotion_type_id"`
				DiscountFee        string `json:"discount_fee"`
			} `json:"order"`
		} `json:"order_promotion"`
		RefundOrder []struct {
			RefundType  string `json:"refund_type"`
			RefundFee   string `json:"refund_fee"`
			RefundId    string `json:"refund_id"`
			RefundState string `json:"refund_state"`
			Oids        string `json:"oids"`
		} `json:"refund_order"`
		FullOrderInfo struct {
			ChildInfo struct {
				GiftNo   string `json:"gift_no"`
				GiftSign string `json:"gift_sign"`
			} `json:"child_info"`
			InvoiceInfo struct {
				UserName          string `json:"user_name"`
				TaxpayerId        string `json:"taxpayer_id"`
				RaiseType         string `json:"raise_type"`
				InvoiceDetailType string `json:"invoice_detail_type"`
			} `json:"invoice_info"`
			RemarkInfo struct {
				Star         string `json:"star"`
				BuyerMessage string `json:"buyer_message"`
				TradeMemo    string `json:"trade_memo"`
			} `json:"remark_info"`
			AddressInfo struct {
				SelfFetchInfo      string `json:"self_fetch_info"`
				DeliveryAddress    string `json:"delivery_address"`
				DeliveryStartTime  string `json:"delivery_start_time"`
				DeliveryEndTime    string `json:"delivery_end_time"`
				DeliveryPostalCode string `json:"delivery_postal_code"`
				ReceiverName       string `json:"receiver_name"`
				DeliveryProvince   string `json:"delivery_province"`
				DeliveryCity       string `json:"delivery_city"`
				AddressExtra       string `json:"address_extra"`
				DeliveryDistrict   string `json:"delivery_district"`
				ReceiverTel        string `json:"receiver_tel"`
			} `json:"address_info"`
			PayInfo struct {
				OuterTransactions string `json:"outer_transactions"`
				PostFee           string `json:"post_fee"`
				TotalFee          string `json:"total_fee"`
				Payment           string `json:"payment"`
				Transaction       string `json:"transaction"`
			} `json:"pay_info"`
			BuyerInfo struct {
				OuterUserId  string `json:"outer_user_id"`
				BuyerPhone   string `json:"buyer_phone"`
				YzOpenId     string `json:"yz_open_id"`
				FansType     string `json:"fans_type"`
				BuyerId      string `json:"buyer_id"`
				FansId       string `json:"fans_id"`
				FansNickname string `json:"fans_nickname"`
			} `json:"buyer_info"`
			Orders []struct {
				TaxTotal             string `json:"tax_total"`
				IsCrossBorder        string `json:"is_cross_border"`
				FenxiaoDiscount      string `json:"fenxiao_discount"`
				OuterItemId          string `json:"outer_item_id"`
				ItemType             string `json:"item_type"`
				DiscountPrice        string `json:"discount_price"`
				Num                  string `json:"num"`
				Freight              string `json:"freight"`
				Discount             string `json:"discount"`
				FenxiaoDiscountPrice string `json:"fenxiao_discount_price"`
				Oid                  string `json:"oid"`
				GoodsSnapshot        string `json:"goods_snapshot"`
				Title                string `json:"title"`
				FenxiaoPayment       string `json:"fenxiao_payment"`
				ItemMessage          string `json:"item_message"`
				ItemNo               string `json:"item_no"`
				BuyerMessages        string `json:"buyer_messages"`
				IsPresent            string `json:"is_present"`
				CrossBorderTradeMode string `json:"cross_border_trade_mode"`
				FenxiaoFreight       string `json:"fenxiao_freight"`
				Price                string `json:"price"`
				SubOrderNo           string `json:"sub_order_no"`
				TotalFee             string `json:"total_fee"`
				FenxiaoPrice         string `json:"fenxiao_price"`
				Alias                string `json:"alias"`
				Payment              string `json:"payment"`
				ItemBarcode          string `json:"item_barcode"`
				OuterSkuId           string `json:"outer_sku_id"`
				GoodsUrl             string `json:"goods_url"`
				CustomsCode          string `json:"customs_code"`
				ItemId               string `json:"item_id"`
				PicPath              string `json:"pic_path"`
				SkuPropertiesName    string `json:"sku_properties_name"`
				SkuId                string `json:"sku_id"`
				PointsPrice          string `json:"points_price"`
				SkuNo                string `json:"sku_no"`
				FenxiaoTaxTotal      string `json:"fenxiao_tax_total"`
				SkuBarcode           string `json:"sku_barcode"`
			} `json:"orders"`
			SourceInfo struct {
				IsOfflineOrder string `json:"is_offline_order"`
				BookKey        string `json:"book_key"`
				Source         struct {
					Platform   string `json:"platform"`
					WxEntrance string `json:"wx_entrance"`
				} `json:"source"`
			} `json:"source_info"`
			OrderInfo struct {
				ConsignTime string `json:"consign_time"`
				OrderExtra  struct {
					IsFromCart                     string `json:"is_from_cart"`
					CashierId                      string `json:"cashier_id"`
					FxKdtId                        string `json:"fx_kdt_id"`
					IdCardName                     string `json:"id_card_name"`
					FxInnerTransactionNo           string `json:"fx_inner_transaction_no"`
					InvoiceTitle                   string `json:"invoice_title"`
					IsSubOrder                     string `json:"is_sub_order"`
					CashierName                    string `json:"cashier_name"`
					IsPointsOrder                  string `json:"is_points_order"`
					SettleTime                     string `json:"settle_time"`
					FxOuterTransactionNo           string `json:"fx_outer_transaction_no"`
					Daogou                         string `json:"daogou"`
					MerchantCustomizedSpecialOrder string `json:"merchant_customized_special_order"`
					ExtraPrices                    string `json:"extra_prices"`
					IsParentOrder                  string `json:"is_parent_order"`
					IdCardNumber                   string `json:"id_card_number"`
					FxOrderNo                      string `json:"fx_order_no"`
					DeptId                         string `json:"dept_id"`
					ParentOrderNo                  string `json:"parent_order_no"`
					PurchaseOrderNo                string `json:"purchase_order_no"`
					CreateDeviceId                 string `json:"create_device_id"`
				} `json:"order_extra"`
				Created       string `json:"created"`
				OfflineId     string `json:"offline_id"`
				StatusStr     string `json:"status_str"`
				ExpiredTime   string `json:"expired_time"`
				SuccessTime   string `json:"success_time"`
				Type          string `json:"type"`
				Tid           string `json:"tid"`
				ConfirmTime   string `json:"confirm_time"`
				PayTime       string `json:"pay_time"`
				UpdateTime    string `json:"update_time"`
				IsRetailOrder string `json:"is_retail_order"`
				PayType       string `json:"pay_type"`
				TeamType      string `json:"team_type"`
				RefundState   string `json:"refund_state"`
				CloseType     string `json:"close_type"`
				Status        string `json:"status"`
				ExpressType   string `json:"express_type"`
				OrderTags     struct {
					IsVirtual             string `json:"is_virtual"`
					IsPurchaseOrder       string `json:"is_purchase_order"`
					IsMember              string `json:"is_member"`
					IsPreorder            string `json:"is_preorder"`
					IsOfflineOrder        string `json:"is_offline_order"`
					IsMultiStore          string `json:"is_multi_store"`
					IsSettle              string `json:"is_settle"`
					IsPayed               string `json:"is_payed"`
					IsSecuredTransactions string `json:"is_secured_transactions"`
					IsPostageFree         string `json:"is_postage_free"`
					IsFenxiaoOrder        string `json:"is_fenxiao_order"`
					IsFeedback            string `json:"is_feedback"`
					IsRefund              string `json:"is_refund"`
				} `json:"order_tags"`
			} `json:"order_info"`
		} `json:"full_order_info"`
	} `json:"msg"`
	KdtName   string `json:"kdt_name"`
	Type      string `json:"type"`
	Version   string `json:"version"`
	KdtId     string `json:"kdt_id"`
	Id        string `json:"id"`
	MsgId     string `json:"msg_id"`
	HeadKdtId string `json:"head_kdt_id"`
	AppId     string `json:"app_id"`
	RootKdtId string `json:"root_kdt_id"`
	Status    string `json:"status"`
}
