package ali

import (
	"context"
	"crypto/hmac"
	"crypto/sha1"
	"encoding/hex"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/util/gconv"
	"sort"
	"strings"
	"time"
)

type Config struct {
	Wsurl       string
	ApiUrl      string
	AppKey      string
	AppSecret   string
	AccessToken string
}

type CommonRes struct {
	Success      bool   `json:"success"`
	ErrorCode    string `json:"errorCode"`
	ErrorMessage string `json:"errorMessage"`
}

var server *Config

const PkgName = "ali"
const WebSite = "1688"

func New(config *Config) {
	server = config
	return
}

func (s *Config) CreateSign(signStr string) (sign string) {
	//拼接参数
	appSecret := []byte(s.AppSecret)
	mac := hmac.New(sha1.New, appSecret)
	mac.Write([]byte(signStr))
	mdStr := hex.EncodeToString(mac.Sum(nil))
	sign = strings.ToUpper(mdStr)
	return
}

func (s *Config) sign(method string, param g.Map) g.Map {
	var keys []string

	mewparam := param
	for k := range mewparam {
		keys = append(keys, k)
	}

	sort.Strings(keys)

	var signStr string
	for _, v := range keys {
		if v != "_aop_signature" {
			signStr += v
			signStr += gconv.String(mewparam[v])
		}
	}
	//拼接参数
	signStr = "param2/1/" + method + "/" + s.AppKey + signStr

	param["_aop_signature"] = s.CreateSign(signStr)

	return param
}

func (s *Config) Post(ctx context.Context, method string, params g.Map) (str string, err error) {
	Start := gtime.TimestampMilli()
	allparams := s.sign(method, params)
	Url := s.ApiUrl + method + "/" + s.AppKey
	Request := g.Client()
	Request.SetHeader("Content-Type", "application/x-www-form-urlencoded")
	resp, err := Request.Timeout(time.Second*5).Post(Url, allparams)
	defer func() {
		_ = resp.Close()
		paramStr := gjson.New(params).MustToJsonString()
		ctx = context.WithValue(ctx, "Method", "POST")
		ctx = context.WithValue(ctx, "URI", Url)
		if err != nil {
			g.Log().Ctx(ctx).Cat(PkgName).Cat("error").Infof("参数【%v】错误【%v】响应时间【%v ms】", paramStr, err.Error(), gtime.TimestampMilli()-Start)
		} else {
			g.Log().Ctx(ctx).Cat(PkgName).Infof("参数【%v】响应【%v】响应时间【%v ms】", paramStr, str, gtime.TimestampMilli()-Start)
		}
	}()
	str = resp.ReadAllString()
	return

}
