package schl

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/util/gconv"
)

type OrderListReq struct {
	UnionNos         []string `json:"unionNos,omitempty"`         //平台订单号数组，最大长度为100
	PlatformOrderNos []string `json:"platformOrderNos,omitempty"` //商户平台订单号数组，最大长度为100
}

type OrderListRes struct {
	CommonRes
	Result []struct {
		UnionNo            string  `json:"unionNo"`            //平台订单号
		PlatformOrderNo    string  `json:"platformOrderNo"`    //商户平台订单号
		TotalAmount        float64 `json:"totalAmount"`        //订单商品总金额
		TotalFreightAmount float64 `json:"totalFreightAmount"` //订单总运费 如开票则含13%税金
		TotalNum           int     `json:"totalNum"`           //订单商品总数
		Province           string  `json:"province"`           //收件人省份
		City               string  `json:"city"`               //收件人城市
		District           string  `json:"district"`           //收件人地区
		AddressDetail      string  `json:"addressDetail"`      //收件人详细地址
		CreateTime         string  `json:"createTime"`         //创建时间
		PayTime            string  `json:"payTime"`            //支付时间
		PayNo              string  `json:"payNo"`              //支付流水号
		CustMobile         string  `json:"custMobile"`         //收件人名称
		CustName           string  `json:"custName"`           //收件人名称
		OrderList          []struct {
			FreightAmount      float64 `json:"freightAmount"` //子单运费
			FreightPayer       int     `json:"freightPayer"`
			InvoiceType        int     `json:"invoiceType"`
			OrderDeliveredList []struct {
				ExpCode     string `json:"expCode"`
				ExpName     string `json:"expName"`
				ExpNo       string `json:"expNo"`
				PackageList []struct {
					DeliveredNum  int    `json:"deliveredNum"`
					DeliveredTime string `json:"deliveredTime"`
					OrderDetailId int    `json:"orderDetailId"`
				} `json:"packageList"`
			} `json:"orderDeliveredList"`
			OrderDetailList []struct {
				Num            int     `json:"num"`
				OrderDetailId  int     `json:"orderDetailId"`
				SpecCode       string  `json:"specCode"`
				SpecInfo       string  `json:"specInfo"`
				SpecName       string  `json:"specName"`
				TaxAmount      float64 `json:"taxAmount"`
				TotalAmount    float64 `json:"totalAmount"`
				TotalTaxAmount float64 `json:"totalTaxAmount"`
				UnitPrice      float64 `json:"unitPrice"`
			} `json:"orderDetailList"`
			State            int     `json:"state"`            //订单状态 -2：已退款 1：已支付 2：已发货 3：已完成
			SuborderId       int     `json:"suborderId"`       //子订单id
			TotalAmount      float64 `json:"totalAmount"`      //子单总金额
			TotalGoodsAmount float64 `json:"totalGoodsAmount"` //子单商品总金额
			TotalTaxAmount   float64 `json:"totalTaxAmount"`
		} `json:"orderList"`
		PayAmount float64 `json:"payAmount"`
	} `json:"result"`
}

func (s *Config) OrderList(ctx context.Context, req OrderListReq) (res *OrderListRes, err error) {

	result, err := s.Post(ctx, "/open/xdxt/api/v2/order/listOrderInfo", gconv.Map(req))
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
