package suning

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type CmmdtyInfoList struct {
	SupplierCode string `json:"supplierCode"`
	SkuId        string `json:"skuId"`
}

type GoodsListPriceReq struct {
	SnRequest struct {
		SnBody struct {
			QueryListpageprice struct {
				CityCode       string            `json:"cityCode"`
				CmmdtyInfoList []*CmmdtyInfoList `json:"cmmdtyInfoList"`
				ChannelCode    string            `json:"channelCode"`
			} `json:"queryListpageprice"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type GoodsListPriceRes struct {
	SnResponseContent struct {
		SnBody struct {
			QueryListpageprice struct {
				Data []struct {
					ReturnCode   string `json:"returnCode"`
					ReturnMsg    string `json:"returnMsg"`
					DeliveryMode string `json:"deliveryMode"`
					CityCode     string `json:"cityCode"`
					Price        string `json:"price"`
					NetPrice     string `json:"netPrice"`
					State        string `json:"state"`
					SupplierCode string `json:"supplierCode"`
					SkuId        string `json:"skuId"`
				} `json:"data"`
			} `json:"queryListpageprice"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 列表页查询价格库存
func GetGoodsListPrice(ctx context.Context, goodsList []*CmmdtyInfoList, cityCode string) (res GoodsListPriceRes, err error) {
	params := GoodsListPriceReq{}
	params.SnRequest.SnBody.QueryListpageprice.CmmdtyInfoList = goodsList
	params.SnRequest.SnBody.QueryListpageprice.CityCode = cityCode
	params.SnRequest.SnBody.QueryListpageprice.ChannelCode = server.ChannelCode

	result, err := post(ctx, "suning.sngoods.listpageprice.query", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type CmmdtyCatInfoList struct {
	Num          string `json:"num"`
	SupplierCode string `json:"supplierCode"`
	SkuId        string `json:"skuId"`
}

type GoodsCatPriceReq struct {
	SnRequest struct {
		SnBody struct {
			QueryShoppingcartprice struct {
				RegionCode     string               `json:"regionCode"`
				CityCode       string               `json:"cityCode"`
				CmmdtyInfoList []*CmmdtyCatInfoList `json:"cmmdtyInfoList"`
				ChannelCode    string               `json:"channelCode"`
			} `json:"queryShoppingcartprice"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type GoodsCatPriceRes struct {
	SnResponseContent struct {
		SnBody struct {
			QueryShoppingcartprice struct {
				Data []struct {
					ReturnCode    string `json:"returnCode"`
					RegionCode    string `json:"regionCode"`
					ReturnMsg     string `json:"returnMsg"`
					CityCode      string `json:"cityCode"`
					Price         string `json:"price"`
					ArrivalQty    string `json:"arrivalQty"`
					State         string `json:"state"`
					SupplierCode  string `json:"supplierCode"`
					DeliveryOrNot string `json:"deliveryOrNot"`
					SkuId         string `json:"skuId"`
				} `json:"data"`
			} `json:"queryShoppingcartprice"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 购物车查询价格库存
func GetGoodsCatPrice(ctx context.Context, goodsList []*CmmdtyCatInfoList, cityCode string) (res GoodsCatPriceRes, err error) {
	params := GoodsCatPriceReq{}
	params.SnRequest.SnBody.QueryShoppingcartprice.CmmdtyInfoList = goodsList
	params.SnRequest.SnBody.QueryShoppingcartprice.CityCode = cityCode
	params.SnRequest.SnBody.QueryShoppingcartprice.ChannelCode = server.ChannelCode

	result, err := post(ctx, "suning.sngoods.shoppingcartprice.query", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
