package kdniao

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type deliverKdniao struct {
}

var Deliver = deliverKdniao{}

type DeliverTrackReq struct {
	CustomerName string `json:"CustomerName"`
	DeliverNo    string `json:"LogisticCode"`
	Code         string `json:"ShipperCode"`
}

type DeliverTrackRes struct {
	EBusinessID  string `json:"EBusinessID"`
	ShipperCode  string `json:"ShipperCode"`
	LogisticCode string `json:"LogisticCode"`
	State        string `json:"State"`
	StateEx      string `json:"StateEx"`
	Location     string `json:"Location"`
	Traces       []struct {
		Action        string `json:"Action"`
		AcceptStation string `json:"AcceptStation"`
		AcceptTime    string `json:"AcceptTime"`
		Location      string `json:"Location"`
	} `json:"Traces"`
	DeliveryMan    string `json:"DeliveryMan"`
	DeliveryManTel string `json:"DeliveryManTel"`
	Success        bool   `json:"Success"`
}

//Track 物流轨迹
func (*deliverKdniao) Track(ctx context.Context, req DeliverTrackReq) (res *DeliverTrackRes, err error) {
	url := "Ebusiness/EbusinessOrderHandle.aspx"
	result, err := post(ctx, url, "8001", req)
	_ = gjson.New(result).Scan(&res)
	return
}

type DeliverParseRes struct {
	LogisticCode string `json:"LogisticCode"`
	Shippers     []struct {
		ShipperName string `json:"ShipperName"`
		ShipperCode string `json:"ShipperCode"`
	} `json:"Shippers"`
	EBusinessID string `json:"EBusinessID"`
	Code        string `json:"Code"`
	Success     bool   `json:"Success"`
}

//Parse 单号识别
func (*deliverKdniao) Parse(ctx context.Context, req string) (res *DeliverParseRes, err error) {
	url := "Ebusiness/EbusinessOrderHandle.aspx"
	result, err := post(ctx, url, "2002", g.Map{
		"LogisticCode": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
