package yz

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/util/gconv"
)

type goodsJD struct {
}

var Goods = goodsJD{}
type UpdateGoodsReq struct {
	Param  UpdateGoodsParam `json:"param"`
}
type UpdateGoodsParam struct {
	ItemId   int `json:"item_id"`
	//NodeKdtId         int `json:"node_kdt_id"`
	ItemDeliveryParam  ItemDeliveryParam `json:"item_delivery_param"`
	ItemWeight int `json:"item_weight"`
	ItemNo     string `json:"item_no"`
	SkuList    []SkuListUpdate `json:"sku_list"`
	Desc          string `json:"desc"`
	ImageIds      []int64  `json:"image_ids"`
	SkuValueProps  []SkuValueProps `json:"sku_value_props"`
	ItemType       int `json:"item_type"`
	ItemPriceParam  ItemPriceParam `json:"item_price_param"`
	Title     string `json:"title"`
	IsDisplay int    `json:"is_display"`
	Quantity  int    `json:"quantity"`
	HideStock int    `json:"hide_stock"`
}
type SkuListUpdate struct {
	//SkuProps  []SkuProps  `json:"sku_props"`
	Price         int    `json:"price"`
	MaxGuidePrice int    `json:"max_guide_price"`
	CostPrice     int    `json:"cost_price"`
	SkuNo         string    `json:"sku_no"`
	StockNum      int    `json:"stock_num"`
	SkuId		int64 `json:"sku_id"`
}
type AddGoodsReq struct {
	Param  AddGoodsParam `json:"param"`
}
type ItemDeliveryParam struct {
	Postage         int `json:"postage"`
	DeliverySetting DeliverySetting  `json:"delivery_setting"`
}
type DeliverySetting struct {
	Express bool `json:"express"`
}
type SkuList struct {
	SkuProps  []SkuProps  `json:"sku_props"`
	Price         int    `json:"price"`
	MaxGuidePrice int    `json:"max_guide_price"`
	CostPrice     int    `json:"cost_price"`
	SkuNo         string    `json:"sku_no"`
	StockNum      int    `json:"stock_num"`
}
type SkuProps struct {
	PropValueName string `json:"prop_value_name"`
	PropName      string `json:"prop_name"`
	PropNameId    int    `json:"prop_name_id"`
	PropValueId   int    `json:"prop_value_id"`

}
type SkuValueProps struct {
	Name  string `json:"name"`
	ImgId int    `json:"img_id"`
	Id    int    `json:"id"`
}
type ItemPriceParam struct {
	Origin    string `json:"origin"`
	CostPrice int `json:"cost_price"`
	Price     int `json:"price"`
}
type AddGoodsParam struct {
	ItemId   int `json:"item_id"`
	//NodeKdtId         int `json:"node_kdt_id"`
	ItemDeliveryParam  ItemDeliveryParam `json:"item_delivery_param"`
	ItemWeight int `json:"item_weight"`
	ItemNo     string `json:"item_no"`
	SkuList    []SkuList `json:"sku_list"`
	Desc          string `json:"desc"`
	ImageIds      []int64  `json:"image_ids"`
	SkuValueProps  []SkuValueProps `json:"sku_value_props"`
	ItemType       int `json:"item_type"`
	ItemPriceParam  ItemPriceParam `json:"item_price_param"`
	Title     string `json:"title"`
	IsDisplay int    `json:"is_display"`
	Quantity  int    `json:"quantity"`
	HideStock int    `json:"hide_stock"`
}
type AddGoodsRes struct {
	CommonRes
	Data    struct {
		ItemId int    `json:"item_id"`
		Alias  string `json:"alias"`
	} `json:"data"`
}
type UplpadImgReq struct {
	Image string `json:"image"`

}
type FindGoodsDataReq struct {
	ItemId int    `json:"item_id"`
}
type FindGoodsDataRes struct {
	CommonRes
	Data GoodsData `json:"data"`

}
type GoodsData struct {
	SkuList []SkuListData `json:"sku_list"`
}
type SkuListData struct {
	SkuId int64 `json:"sku_id"`
	SkuNo string `json:"sku_no"`
}
// type UplpadImgRes struct {
// 	CommonRes
// 	Data struct {
// 		ImageId int64 `json:"image_id"`
// 	} `json:"data"`

// }

type UplpadImgRes struct {
	CommonRes
	Data    struct {
		KdtId    int    `json:"kdt_id"`
		ImageUrl string `json:"image_url"`
		Width    int    `json:"width"`
		ImageId  int64  `json:"image_id"`
		Height   int    `json:"height"`
	} `json:"data"`
}
// 添加商品
func (*goodsJD) AddGoods(ctx context.Context, req *AddGoodsReq) (res *AddGoodsRes, err error) {
	method := "youzan.item.add/1.0.1"
	param := gconv.Map(req)

	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

// 编辑商品
func (*goodsJD) UpdateGoods(ctx context.Context, req *UpdateGoodsReq) (res *AddGoodsRes, err error) {

	method := "youzan.item.incremental.update/1.0.1"
	param := gconv.Map(req)
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}

// 图片上传
func (*goodsJD) UploadImg(ctx context.Context, req *UplpadImgReq) (res *UplpadImgRes, err error) {
	method := "youzan.materials.storage.platform.img.upload/3.0.0"
	//param := gconv.Map(req)
	//param = map[string]interface{}{
	//	"image" : req.Image,
	//}
	result, err := server.requestApiImg(ctx, method, req.Image)
	if err != nil {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}
// 商品详情
func (*goodsJD) FindGoodsData(ctx context.Context, req *FindGoodsDataReq) (res *FindGoodsDataRes, err error) {
	method := "youzan.item.detail.get/1.0.0"
	param := gconv.Map(req)
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}
//type UpDateStockReq struct {
//	Quantity string `json:"quantity"`
//	ItemId   string `json:"item_id"`
//	SkuId    string `json:"sku_id"`
//	Type     string `json:"type"`
//}
//type UpDateStockRes struct {
//	Code int `json:"code"`
//	Data struct {
//		IsSuccess bool `json:"is_success"`
//	} `json:"data"`
//	Success bool   `json:"success"`
//	Message string `json:"message"`
//}
//// 图片上传
//func (*goodsJD) UpDateStock(ctx context.Context, req *UpDateStockReq) (res *UpDateStockRes, err error) {
//	method := "youzan.item.quantity.update/3.0.0"
//	param := gconv.Map(req)
//	result, err := server.requestApi(ctx, method, param)
//	if err != nil {
//		return
//	}
//	err = json.Unmarshal([]byte(result), &res)
//	return
//}1