package gome

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type logisticsGome struct {
}

var Logistics = logisticsGome{}

type GetLogisticsRes struct {
	*CommonRes
	Data struct {
		LogisticsDtoList []struct {
			LogisticsCode string `json:"logisticsCode"`
			LogisticsName string `json:"logisticsName"`
		} `json:"logisticsDtoList"`
	} `json:"data"`
}

func (logisticsGome) Get(ctx context.Context) (res *GetLogisticsRes, err error) {
	method := "alemein.basic.get.logistics"
	req := g.Map{}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
