package gome

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type orderGome struct {
}

var Order = orderGome{}

type CreateOrderReq struct {
	OuterOrderId    string `json:"outerOrderId"`
	OnlinePayAmount int    `json:"onlinePayAmount"`
	ConsigneeInfo   struct {
		ReceiverName   string `json:"receiverName"`
		ReceiverMobile int64  `json:"receiverMobile"`
		County         int    `json:"county"`
		Town           int    `json:"town"`
		StateName      string `json:"stateName"`
		CityName       string `json:"cityName"`
		CountyName     string `json:"countyName"`
		TownName       string `json:"townName"`
		DetailAddress  string `json:"detailAddress"`
	} `json:"consigneeInfo"`
	SkuItems []struct {
		OuterSkuItemId string `json:"outerSkuItemId"`
		MchSkuId       int    `json:"mchSkuId"`
		Quantity       int    `json:"quantity"`
		DealPrice      int    `json:"dealPrice"`
		MchWhseCode    string `json:"mchWhseCode"`
	} `json:"skuItems"`
}

type CreateOrderRes struct {
	*CommonRes
	Data bool `json:"data"`
}

type OrderInfoRes struct {
	*CommonRes
	Data struct {
		OuterOrderId      string `json:"outerOrderId"`
		Finished          string `json:"finished"`
		DeliveryOrderList []struct {
			DeliveryId     string `json:"deliveryId"`
			DeliveryStatus string `json:"deliveryStatus"`
			SkuItemList    []struct {
				SkuItemId      string `json:"skuItemId"`
				OuterSkuItemId string `json:"outerSkuItemId"`
				MchSkuId       string `json:"mchSkuId"`
				Quantity       int    `json:"quantity"`
			} `json:"skuItemList"`
		} `json:"deliveryOrderList"`
	} `json:"data"`
}

type OrderStatusRes struct {
	*CommonRes
	Data struct {
		DeliveryId        string `json:"deliveryId"`
		CurrentStatus     string `json:"currentStatus"`
		CurrentStatusTime string `json:"currentStatusTime"`
		PastStatuses      []struct {
			Status     string `json:"status"`
			StatusTime string `json:"statusTime"`
		} `json:"pastStatuses"`
	} `json:"data"`
}

type OrderLogisticsRes struct {
	*CommonRes
	Data struct {
		DeliveryId   string `json:"deliveryId"`
		CompanyCode  string `json:"companyCode"`
		CompanyName  string `json:"companyName"`
		CompanyPhone string `json:"companyPhone"`
		WaybillCode  string `json:"waybillCode"`
		CourierName  string `json:"courierName"`
		CourierPhone string `json:"courierPhone"`
		Tracks       []struct {
			TrackTime   string `json:"trackTime"`
			Description string `json:"description"`
		} `json:"tracks"`
	} `json:"data"`
}

type OrderCancelReq struct {
	DeliveryId   string `json:"deliveryId"`
	OuterOrderId string `json:"outerOrderId"`
	CancelTime   string `json:"cancelTime"`
}

//Create 提交订单
func (orderGome) Create(ctx context.Context, req *CreateOrderReq) (res *CreateOrderRes, err error) {
	method := "alamein.order.write.submitAndConfirm"

	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//Info 订单详情
func (orderGome) Info(ctx context.Context, sn string) (res *OrderInfoRes, err error) {
	method := "alamein.order.read.querySubmitAndConfirmResult"

	var req = g.Map{
		"outerOrderId": sn,
	}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//Status 订单关键状态查询
func (orderGome) Status(ctx context.Context, deliveryId string) (res *OrderStatusRes, err error) {
	method := "alamein.order.read.queryKeyStatus"

	var req = g.Map{
		"deliveryId": deliveryId,
	}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//Logistics 物流
func (orderGome) Logistics(ctx context.Context, deliveryId string) (res *OrderLogisticsRes, err error) {
	method := "alamein.order.read.queryLogisticsTrack"

	var req = g.Map{
		"deliveryId": deliveryId,
	}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//Cancel 支付后取消申请
func (orderGome) Cancel(ctx context.Context, req *OrderCancelReq) (res *CommonRes, err error) {
	method := "alamein.order.read.queryLogisticsTrack"

	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
