package hcw

import (
	"encoding/json"
	"errors"
	"github.com/gogf/gf/net/ghttp"
	"github.com/gogf/gf/util/gconv"
)

// order_shipped	订单发货	{ "order_no":"P123"}
// refund_result	发起售后成功	{ "order_no":100.00}
// product_status	产品状态变更(1上架2下架)	{ "product_no":"SKU123"}
type OrderNotifyRes struct {
	OrderNo   string `json:"order_no"`
	ProductNo string `json:"product_no"`
	RefundNo  string `json:"refund_no"`
	Type      string `json:"type"`
	Source    string `json:"source"`
}

// 回调
func (s *HcwClient) CallBack(r *ghttp.Request) (res *OrderNotifyRes, err error) {
	body := r.GetBodyString()
	if body == "" {
		return
	}
	err = json.Unmarshal([]byte(body), &res)
	if nil != err {
		return
	}
	signature := r.GetHeader("signature")
	err = s.CheckSign(signature, res)

	return
}

func (s *HcwClient) CheckSign(signature string, req *OrderNotifyRes) (err error) {
	reqMap := gconv.Map(req)
	signatureStr, err := s.EncryptWithSignature(reqMap)
	if signature != signatureStr {
		err = errors.New("incorrect signature")
	}

	return
}
