package hcw

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type GoodsListReq struct {
	Page      string `json:"page"`       //页数
	PageSize  string `json:"page_size"`  //条数
	Source    string `json:"source"`     //商品来源
	Name      string `json:"name"`       //商品名称（支持模糊查询）
	Status    string `json:"status"`     //商品状态（1上架2下架）
	ProductNo string `json:"product_no"` //商品编码
	Model     string `json:"model"`      //商品型号（支持模糊查询）
}

type GoodsListRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Data    struct {
		List []struct {
			Id         int         `json:"id"`
			ProductNo  string      `json:"product_no"`
			Source     string      `json:"source"`
			PlatNo     interface{} `json:"plat_no"`
			Name       string      `json:"name"`
			BrandNo    int         `json:"brand_no"`
			CategoryNo int         `json:"category_no"`
			Price      string      `json:"price"`
			Stock      int         `json:"stock"`
			Image      string      `json:"image"`
			Images     []string    `json:"images"`
			Content    string      `json:"content"`
			Status     int         `json:"status"`
			CreatedAt  string      `json:"created_at"`
			UpdatedAt  string      `json:"updated_at"`
			DeletedAt  interface{} `json:"deleted_at"`
		} `json:"list"`
		Total int `json:"total"`
	} `json:"data"`
}

// 商品列表
func (s *HcwClient) GoodsList(ctx context.Context, req *GoodsListReq) (res *GoodsListRes, err error) {
	var method = "/api/v1/product"
	result, err := s.get(ctx, method, req)
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsDetailReq struct {
	Source string `json:"source"` //商品来源
}

type GoodsDetailRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Data    struct {
		Id         int         `json:"id"`
		ProductNo  string      `json:"product_no"`
		Source     string      `json:"source"`
		PlatNo     interface{} `json:"plat_no"`
		Name       string      `json:"name"`
		BrandNo    int         `json:"brand_no"`
		CategoryNo int         `json:"category_no"`
		Price      string      `json:"price"`
		Stock      int         `json:"stock"`
		Image      string      `json:"image"`
		Images     []string    `json:"images"`
		Content    string      `json:"content"`
		Status     int         `json:"status"`
		CreatedAt  string      `json:"created_at"`
		UpdatedAt  string      `json:"updated_at"`
		Sku        struct {
			ProductNo string `json:"product_no"`
			SkuNo     string `json:"sku_no"`
			Model     string `json:"model"`
			Name      string `json:"name"`
			Value     string `json:"value"`
			Image     string `json:"image"`
			Stock     int    `json:"stock"`
			Price     int    `json:"price"`
		} `json:"sku"`
	} `json:"data"`
}

// 商品详情
func (s *HcwClient) GoodsDetail(ctx context.Context, productSn, source string) (res *GoodsDetailRes, err error) {
	var method = "/api/v1/product/" + productSn
	req := &GoodsDetailReq{}
	req.Source = source
	result, err := s.get(ctx, method, req)
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
