package schl

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type brandLogic struct {
}

var Brand = brandLogic{}

type BrandListRes struct {
	CommonRes
	Result []struct {
		BrandImg  string `json:"brandImg"`
		BrandName string `json:"brandName"`
		Id        int    `json:"id"`
	} `json:"result"`
}

// BrandList 获取商品品牌
func (s *Config) BrandList(ctx context.Context) (res *BrandListRes, err error) {
	result, err := s.Post(ctx, "/open/xdxt/api/v2/goods/listGoodsBrand", g.Map{})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
