package schl

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/util/gconv"
)

type OrderCreateReq struct {
	PlatformOrderNo  string            `json:"platformOrderNo"`
	FreightPayer     int               `json:"freightPayer"`
	InvoiceHeaderId  int               `json:"invoiceHeaderId"`
	InvoiceType      int               `json:"invoiceType"`
	CustName         string            `json:"custName"`
	CustMobile       string            `json:"custMobile"`
	Province         string            `json:"province"`
	City             string            `json:"city"`
	District         string            `json:"district"`
	AddressDetail    string            `json:"addressDetail"`
	ExpCode          string            `json:"expCode"`
	OrderDetailsList []OrderCreateItem `json:"orderDetailsList"`
}

type OrderCreateItem struct {
	Code string `json:"code"`
	Num  int    `json:"num"`
}

type OrderCreateRes struct {
	Code   int    `json:"code"`
	Msg    string `json:"msg"`
	Result struct {
		UnionNo          string  `json:"unionNo"`
		TotalNum         int     `json:"totalNum"`
		ExpFeeAmount     float64 `json:"expFeeAmount"`
		GoodsMoneyAmount int     `json:"goodsMoneyAmount"`
		PayMoney         float64 `json:"payMoney"`
		OrderList        []struct {
			SuborderId       int     `json:"suborderId"`
			TotalGoodsAmount int     `json:"totalGoodsAmount"`
			FreightAmount    float64 `json:"freightAmount"`
			TotalAmount      float64 `json:"totalAmount"`
			OrderDetailList  []struct {
				OrderDetailId int    `json:"orderDetailId"`
				SpecCode      string `json:"specCode"`
				SpecName      string `json:"specName"`
				SpecInfo      string `json:"specInfo"`
				Num           int    `json:"num"`
				UnitPrice     int    `json:"unitPrice"`
				TotalAmount   int    `json:"totalAmount"`
			} `json:"orderDetailList"`
		} `json:"orderList"`
	} `json:"result"`
}

// OrderCreate 创建订单
func (s *Config) OrderCreate(ctx context.Context, req OrderCreateReq) (res *OrderCreateRes, err error) {

	result, err := s.Post(ctx, "/open/xdxt/api/v2/order/createOrder", gconv.Map(req))
	if err != nil {
		return
	}

	err = gjson.New(result).Scan(&res)
	return
}
