package schl

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type OrderEventRes struct {
	CommonRes
	Result []struct {
		EventKey       string `json:"eventKey"`
		EventDesc      string `json:"eventDesc"`
		ChangesContent []struct {
			UnionNo            string `json:"unionNo"`
			OrderDeliveredList []struct {
				ExpName     string `json:"expName"`
				ExpNo       string `json:"expNo"`
				ExpCode     string `json:"expCode"`
				PackageList []struct {
					OrderDetailId int    `json:"orderDetailId"`
					DeliveredNum  int    `json:"deliveredNum"`
					DeliveredTime string `json:"deliveredTime"`
				} `json:"packageList"`
			} `json:"orderDeliveredList"`
		} `json:"changesContent"`
	} `json:"result"`
}

func (s *Config) OrderEvent(ctx context.Context) (res *OrderEventRes, err error) {

	result, err := s.Post(ctx, "/open/xdxt/api/v2/order/listOrderChangeEvent", g.Map{})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
