package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type GoodsSkuReq struct {
	DivisionCode   string
	PurchaserId    string
	SkuQueryParams []GoodsSkuItem
}

type GoodsSkuItem struct {
	ProductId string `json:"productId"`
	SkuId     string `json:"skuId"`
}

type GoodsSkuRes struct {
	RequestId    string `json:"requestId"`
	SkuSaleInfos []struct {
		CanSell       bool   `json:"canSell"`
		FuzzyQuantity string `json:"fuzzyQuantity"`
		MarkPrice     int    `json:"markPrice"`
		Price         int    `json:"price"`
		ProductId     string `json:"productId"`
		Quantity      int    `json:"quantity"`
		ShopId        string `json:"shopId"`
		SkuId         string `json:"skuId"`
		SkuStatus     string `json:"skuStatus"`
		Title         string `json:"title"`
	} `json:"skuSaleInfos"`
}

// Sku 批量查询选品池SKU销售信息
func (s goodsTm) Sku(ctx context.Context, req GoodsSkuReq) (res *GoodsSkuRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "ListSelectionSkuSaleInfos")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	if req.PurchaserId == "" {
		req.PurchaserId = PurchaserId
	}
	Request := &client.ListSelectionSkuSaleInfosRequest{}
	var Body = new(client.SkuSaleInfoListQuery)
	Body.SetPurchaserId(req.PurchaserId)
	if req.DivisionCode != "" {
		Body.SetDivisionCode(req.DivisionCode)
	}
	var list []*client.SkuQueryParam
	for _, item := range req.SkuQueryParams {
		list = append(list, &client.SkuQueryParam{
			ProductId: tea.String(item.ProductId),
			SkuId:     tea.String(item.SkuId),
		})
	}
	Body.SetSkuQueryParams(list)
	Request.SetBody(Body)

	r, err := server.ListSelectionSkuSaleInfos(Request)
	if err != nil {
		return
	}
	err = gjson.New(r.Body).Scan(&res)
	return
}
