package yonghui

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/encoding/gjson"
	"strings"
)

var Msg = new(msg)

type msg struct {
}

type MsgPullReq struct {
	MessageType string `json:"messageType"`
	PageNo      string `json:"pageNo"`
	PageSize    string `json:"pageSize"`
}

type MsgPullRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    []struct {
		Id          json.Number `json:"id"`
		Type        int         `json:"type"`
		CreateTime  string      `json:"createTime"`
		MessageInfo string      `json:"messageInfo"`
	} `json:"data"`
}

/*
*
正向订单
*/
type MsgOrder struct {
	CsxOrderCode   string `json:"csxOrderCode"`
	ThirdOrderCode string `json:"thirdOrderCode"`
	OrderStatus    string `json:"orderStatus"`
}

/*
*
售后订单
*/
type MsgOrderRefund struct {
	AfterSalesOrderCode string `json:"afterSalesOrderCode"`
	ThirdAfterSalesCode string `json:"thirdAfterSalesCode"`
	ThirdOrderCode      string `json:"thirdOrderCode"`
	CsxOrderCode        string `json:"csxOrderCode"`
	AfterSalesStatus    string `json:"afterSalesStatus"`
	RefundStatus        string `json:"refundStatus"`
	IsOffline           bool   `json:"isOffline"`
}

/*
*
物流发货
*/
type MsgLogistic struct {
	CsxOrderCode   string `json:"csxOrderCode"`
	ThirdOrderCode string `json:"thirdOrderCode"`
	LogisticCode   string `json:"logisticCode"`
	ShipperCode    string `json:"shipperCode"`
	LogisticStatus string `json:"logisticStatus"`
}

/*
*
商品变更
*/
type MsgGoodsChange struct {
	GoodsCode string `json:"goodsCode"`
}

/*
*
商品上下架
*/
type MsgGoodsShelves struct {
	GoodsCode   string `json:"goodsCode"`
	GoodsStatus string `json:"goodsStatus"`
}

/*
*
商品价格变更
*/
type MsgGoodsPrice struct {
	GoodsCode  string `json:"goodsCode"`
	GoodsPrice string `json:"goodsPrice"`
}

/*
*
消息拉取
*/
func (s *msg) Pull(ctx context.Context, req *MsgPullReq) (res *MsgPullRes, err error) {
	result, err := post(ctx, "com.csx.message-pull.do", req)
	if nil != err {
		return
	}
	decoder := json.NewDecoder(strings.NewReader(result))
	decoder.UseNumber()
	decoder.Decode(&res)
	return
}

type MsgRemoveReq struct {
	MessageIds string `json:"messageIds"`
}

type MsgRemoveRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    string `json:"data"`
}

/*
*
删除消息
*/
func (s *msg) Remove(ctx context.Context, req *MsgRemoveReq) (res *MsgRemoveRes, err error) {
	result, err := post(ctx, "com.csx.message-remove.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
