package yunzmall

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type logisticsLogic struct {
}

var Logistics = logisticsLogic{}

type LogisticsCompanyRes struct {
	CommonRes
	Data struct {
		List []struct {
			Code string `json:"code"`
			Name string `json:"name"`
		} `json:"list"`
	} `json:"data"`
}

// LogisticsCompany 快递公司
func (s *Client) LogisticsCompany(ctx context.Context) (res *LogisticsCompanyRes, err error) {
	var method = "/app/order/cloud/company/list"
	result, err := s.get(ctx, method, g.Map{})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type LogisticsTraceRes struct {
	CommonRes
	Data []struct {
		Id          int    `json:"id"`
		ExpressNo   string `json:"express_no"`
		CompanyCode string `json:"company_code"`
		CompanyName string `json:"company_name"`
		CreatedAt   int    `json:"created_at"`
		OrderItems  []struct {
			Id        int    `json:"id"`
			ImageUrl  string `json:"image_url"`
			ProductId int    `json:"product_id"`
			Title     string `json:"title"`
			SkuTitle  string `json:"sku_title"`
			SkuId     int    `json:"sku_id"`
			Qty       int    `json:"qty"`
			SendNum   int    `json:"send_num"`
		} `json:"order_items"`
	} `json:"data"`
}

//LogisticsDelivery 获取物流信息
func (s *Client) LogisticsDelivery(ctx context.Context, req string) (res *LogisticsTraceRes, err error) {
	var method = "/app/order/Logistic"
	result, err := s.post(ctx, method, g.Map{
		"order_sn": req,
	})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
